<?php get_header(); ?>

<section class="archive-page">
    <div class="tc-wrapper">
    	<?php
    		$terms = get_terms( array(
				    'taxonomy' => 'package_type',
				    'hide_empty' => true,
				    'parent' 	=> 0,
				   ) );
    		foreach ($terms as $term) {
    			# code...
    			$pterms_id = $term->term_id;
    			$dest_name = $term->name;
    			$destination = $term->slug;
    			$child_terms = get_term_children( $pterms_id, 'package_type' );
    			$pterm_link = get_term_link( $term, 'package_type' );
    			
    			foreach ($child_terms as $child_term) {
    				# code...

    				$cterm = get_term_by( 'id', $child_term, 'package_type' );
    				$act_name = $cterm->name;
    				$activity = $cterm->slug;
    				$cterm_link =get_term_link(  $cterm, 'package_type' );
    				$args = array(
						'post_type' =>'package',
						 'tax_query' => array(
						 	'relation' => 'AND',
				                        array(
							        'taxonomy' => 'package_type',
							        'field'    => 'slug',
							        'terms'    => array( $destination ),
				                        ),
				                        array(
				                                'taxonomy' =>'package_type',
				                                'field'    => 'slug',
				                                'terms'    => array( $activity ),
				                        ),
				                    ),
					);
					$query = new WP_Query($args);
					if($query->have_posts()){
						?>
						 <div class="archive-list">
			            <div class="row">
			                <div class="col-12">	
			                    <h3 class="top-title"><a href="<?php echo $pterm_link;?>" class="title"><?php echo $dest_name;?></a> <i class="fa fa-angle-double-right"></i> <a href="<?php echo $cterm_link;?>" class="title"><?php echo $act_name;?></a></h3>
			                </div>
			            </div>
			            <div class="row">
			                <div class="owl-carousel owl-theme dest-slider">
						<?php

						while($query->have_posts()){

							$query->the_post();
							$post_id = get_the_ID();
							$post_thumbnail = get_the_post_thumbnail_url($post_id);
							$price = get_post_field('price',$post_id);
							$post_title = get_the_title( $post_id );
							$duration = get_post_field('duration',$post_id);
							?>
					
			                    <div class="col-12">
			                        <div class="item">
			                            <div class="best-trip">
			            					<span class="tours-price"><?php echo '$'.$price;?></span>
			            					<a href="<?php echo get_the_permalink($post_id);?>"><img src="<?php echo $post_thumbnail; ?>" class="pack-img"></a>
			            					<div class="row">
			            						<div class="col-12">
			            							<h3><a href="<?php echo get_the_permalink($post_id);?>"><?php echo $post_title;?></a></h3>
			            						</div>
			            						<div class="col-12">
			            							<div class="inner"><span class="day-night-alt"><?php echo $duration;?></span></div>
			            						</div>
			            					</div>
			            				</div>
			                        </div>
			                    </div>
			                   
			                
        <?php

						}
						wp_reset_postdata();
						?>
						</div>
			           		 </div>    
			     			   </div>
						<?php
					}
    			}

    		}
    	?>
       
        
      
    </div>
</section>

<?php get_footer(); ?>