<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Jugal_Holidays
 */

?>
<!DOCTYPE HTML>
<html lang = "en">
<html <?php language_attributes(); ?>>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="google-adsense-account" content="ca-pub-2198660225430770">
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-2198660225430770"
     crossorigin="anonymous"></script>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<link rel="profile" href="https://gmpg.org/xfn/11">
<!-- 	<link href="https://fonts.googleapis.com/css?family=Muli|Roboto&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Montserrat|Handlee&display=swap" rel="stylesheet"> -->
	<link href="https://use.fontawesome.com/releases/v5.5.0/css/all.css" rel="stylesheet">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="language" content="English">
	<meta name="revisit-after" content="1 days">
	<meta name="author" content="iceberg Technology">
	<script data-ad-client="ca-pub-9818673900351802" async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>


<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-J4FZQ3WVNR"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-J4FZQ3WVNR');
</script>
	
	<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Quicksand:wght@300..700&family=Satisfy&family=Rubik:ital,wght@0,300..900;1,300..900&family=DM+Serif+Display:ital@0;1&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap" rel="stylesheet">
		
	<?php wp_head(); ?>
	
	
	
</head>

<body <?php body_class(); ?>>	
	<?php $my_option =get_option( 'jugal_framework' );  ?>
	<div id="page" class="site">
		<div class="site-header">
			<header class="header">
				<div class="header-top">
					<div class="header-container">
						<ul class="header-contact">
							<li class="contact-icon">
								<a href="tel:+9779851008066" aria-label="Phone" class="phone"><i class="fa-solid fa-phone"></i></a>
								<a href="tel:+9779851008066" aria-label="Whatsapp" class="whatsapp"><i class="fa-brands fa-whatsapp"></i> </a>
								<a href="tel:+9779851008066" aria-label="Viber" class="viber"><i class="fa-brands fa-viber"></i></a>
								<?php 
								$phones = $my_option['contact'];
								if(!empty($phones)){
									$cnt = count($phones);
									$i=1;
									foreach($phones as $phone){
										if($i == 1){
											?>
											<a href="tel:<?php echo $phone['contact_number'];?>"><?php echo $phone['contact_number'];?></a>
											<?php
										}

										$i++;
									}
								}
								?>
							</li>
							<li>
								<i class="fa-solid fa-envelope-open-text"></i>
								<?php
								$emails = $my_option['cont_email'];
								if(!empty($emails)){
									$cnt = count($emails);
									$i=1;
									foreach($emails as $email){
										if($i==1){
											?>
											<a href="mailto:<?php echo $email['contact_email'];?>"><?php echo $email['contact_email'];?></a>
											<?php
										}
										$i++;
									}
								}
								?>
							</li>
						</ul> 
						<ul class="social-icon">
							<?php if(!empty($my_option['facebook'])){ ?>
							<li>
								<a target="_blank" href="<?php echo $my_option['facebook']; ?>" class="face"><i class="fab fa-facebook-f"></i></a>
							</li>
							<?php } ?>
							<?php if(!empty($my_option['twitter'])){ ?>
							<li>
								<a target="_blank" href="<?php echo $my_option['twitter'];?>" class="twit"><i class="fa-brands fa-x-twitter"></i>								 </a>
							</li>
							<?php } ?>
							<?php if(!empty($my_option['instagram'])){	?>
							<li>
								<a target="_blank" href="<?php echo $my_option['instagram'];?>" class="insta"><i class="fab fa-instagram"></i></a>							  </li>
							<?php } ?>
							<?php	if(!empty($my_option['googleplus'])){ ?>
							<li>
								<a target="_blank" href="<?php echo $my_option['googleplus'];?>" class="goog"><i class="fab fa-google-plus-g"></i>								  </a>
							</li>
							<?php }	?>
							<li>
								<a href="" target="_blank">
									<img src="<?php echo home_url(); ?>/wp-content/uploads/2025/01/ta.png" alt="tripadvisor">
								</a>
							</li>
						</ul>
					</div>
				</div>
				<div class="header-container">
					<div class="header-btm">
						<div class="logo">
							<a href="<?php echo home_url(); ?>">
								<img src="<?php echo home_url('/wp-content/uploads/2024/02/logo-2.png'); ?>" alt="Jugal Holidays Pvt. Ltd.">
								<div class="logo-text">
									<span class="logo-title"><?php
										$my_option =get_option( 'jugal_framework' ); 
										echo $my_option['site_title']; ?></span>
										<small class="logo-subtitle">Your Reliable Partner In Nepal</small>
								</div>
							</a>
						</div>
						<div class="nav-menu">
						<?php wp_nav_menu(array('theme_location' => 'menu-1')); ?>
						</div>
					</div>
				</div>
			</header>
		</div>