<?php
function custom_post_type_registration() {
    $labels = array(
        'name'                  => _x( 'Packages', 'Post type general name', 'jugal-holidays' ),
        'singular_name'         => _x( 'Package', 'Post type singular name', 'jugal-holidays' ),
        'menu_name'             => _x( 'Packages', 'Admin Menu text', 'jugal-holidays' ),
        'name_admin_bar'        => _x( 'Package', 'Add New on Toolbar', 'jugal-holidays' ),
        'add_new'               => __( 'Add New', 'jugal-holidays' ),
        'add_new_item'          => __( 'Add New Package', 'jugal-holidays' ),
        'new_item'              => __( 'New Package', 'jugal-holidays' ),
        'edit_item'             => __( 'Edit Package', 'jugal-holidays' ),
        'view_item'             => __( 'View Package', 'jugal-holidays' ),
        'all_items'             => __( 'All Packages', 'jugal-holidays' ),
        'search_items'          => __( 'Search Packages', 'jugal-holidays' ),
        'parent_item_colon'     => __( 'Parent Packages:', 'jugal-holidays' ),
        'not_found'             => __( 'No packages found.', 'jugal-holidays' ),
        'not_found_in_trash'    => __( 'No packages found in Trash.', 'jugal-holidays' ),
        'featured_image'        => _x( 'Package Cover Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'set_featured_image'    => _x( 'Set cover image', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'remove_featured_image' => _x( 'Remove cover image', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'use_featured_image'    => _x( 'Use as cover image', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'archives'              => _x( 'Package archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', 'jugal-holidays' ),
        'insert_into_item'      => _x( 'Insert into package', 'Overrides the “Insert into post”/”Insert into page” phrase (used when inserting media into a post). Added in 4.4', 'jugal-holidays' ),
        'uploaded_to_this_item' => _x( 'Uploaded to this package', 'Overrides the “Uploaded to this post”/”Uploaded to this page” phrase (used when viewing media attached to a post). Added in 4.4', 'jugal-holidays' ),
        'filter_items_list'     => _x( 'Filter packages list', 'Screen reader text for the filter links heading on the post type listing screen. Default “Filter posts list”/”Filter pages list”. Added in 4.4', 'jugal-holidays' ),
        'items_list_navigation' => _x( 'Packages list navigation', 'Screen reader text for the pagination heading on the post type listing screen. Default “Posts list navigation”/”Pages list navigation”. Added in 4.4', 'jugal-holidays' ),
        'items_list'            => _x( 'Packages list', 'Screen reader text for the items list heading on the post type listing screen. Default “Posts list”/”Pages list”. Added in 4.4', 'jugal-holidays' ),
    );
 
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'package' ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-location-alt',
        'supports'           => array( 'title', 'author', 'thumbnail', 'excerpt', 'comments' ),
    );
 
    register_post_type( 'package', $args );

        unset($args);
    //postype for why choose us
    $labels = array(
        'name'                  => _x( 'Why Choose Us', 'Post type general name', 'jugal-holidays' ),
        'singular_name'         => _x( 'Why Choose Us', 'Post type singular name', 'jugal-holidays' ),
        'menu_name'             => _x( 'Why Choose Us', 'Admin Menu text', 'jugal-holidays' ),
        'name_admin_bar'        => _x( 'Why Choose Us', 'Add New on Toolbar', 'jugal-holidays' ),
        'add_new'               => __( 'Add New', 'jugal-holidays' ),
        'add_new_item'          => __( 'Add New Why Choose Us', 'jugal-holidays' ),
        'new_item'              => __( 'New Why Choose Us', 'jugal-holidays' ),
        'edit_item'             => __( 'Edit Why Choose Us', 'jugal-holidays' ),
        'view_item'             => __( 'View Why Choose Us', 'jugal-holidays' ),
        'all_items'             => __( 'All Why Choose Us', 'jugal-holidays' ),
        'search_items'          => __( 'Search Why Choose Us', 'jugal-holidays' ),
        'parent_item_colon'     => __( 'Parent Why Choose Us:', 'jugal-holidays' ),
        'not_found'             => __( 'No packages found.', 'jugal-holidays' ),
        'not_found_in_trash'    => __( 'No packages found in Trash.', 'jugal-holidays' ),
        'featured_image'        => _x( 'Why Choose Us Cover Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'set_featured_image'    => _x( 'Set cover image', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'remove_featured_image' => _x( 'Remove cover image', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'use_featured_image'    => _x( 'Use as cover image', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'archives'              => _x( 'Why Choose Us archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', 'jugal-holidays' ),
        'insert_into_item'      => _x( 'Insert into package', 'Overrides the “Insert into post”/”Insert into page” phrase (used when inserting media into a post). Added in 4.4', 'jugal-holidays' ),
        'uploaded_to_this_item' => _x( 'Uploaded to this package', 'Overrides the “Uploaded to this post”/”Uploaded to this page” phrase (used when viewing media attached to a post). Added in 4.4', 'jugal-holidays' ),
        'filter_items_list'     => _x( 'Filter packages list', 'Screen reader text for the filter links heading on the post type listing screen. Default “Filter posts list”/”Filter pages list”. Added in 4.4', 'jugal-holidays' ),
        'items_list_navigation' => _x( 'Why Choose Us list navigation', 'Screen reader text for the pagination heading on the post type listing screen. Default “Posts list navigation”/”Pages list navigation”. Added in 4.4', 'jugal-holidays' ),
        'items_list'            => _x( 'Why Choose Us list', 'Screen reader text for the items list heading on the post type listing screen. Default “Posts list”/”Pages list”. Added in 4.4', 'jugal-holidays' ),
    );
 
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'taxonomies'         => array(),
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'why_choose_us' ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-clipboard',
        'supports'           => array( 'title', 'thumbnail', 'excerpt' ),
    );
 
    register_post_type( 'why_choose_us', $args );


   
 

   //postype for Booking
    $labels = array(
        'name'                  => _x( 'Booking Lists', 'Post type general name', 'jugal-holidays' ),
        'singular_name'         => _x( 'Booking List', 'Post type singular name', 'jugal-holidays' ),
        'menu_name'             => _x( 'Booking List', 'Admin Menu text', 'jugal-holidays' ),
        'name_admin_bar'        => _x( 'Booking List', 'Add New on Toolbar', 'jugal-holidays' ),
        'add_new'               => __( 'Add New', 'jugal-holidays' ),
        'add_new_item'          => __( 'Add New Booking List', 'jugal-holidays' ),
        'new_item'              => __( 'New Booking List', 'jugal-holidays' ),
        'edit_item'             => __( 'Edit Booking List', 'jugal-holidays' ),
        'view_item'             => __( 'View Booking List', 'jugal-holidays' ),
        'all_items'             => __( 'All Booking List', 'jugal-holidays' ),
        'search_items'          => __( 'Search Booking List', 'jugal-holidays' ),
        'parent_item_colon'     => __( 'Parent Booking List:', 'jugal-holidays' ),
        'not_found'             => __( 'No packages found.', 'jugal-holidays' ),
        'not_found_in_trash'    => __( 'No packages found in Trash.', 'jugal-holidays' ),
        'featured_image'        => _x( 'Booking List Cover Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'set_featured_image'    => _x( 'Set cover image', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'remove_featured_image' => _x( 'Remove cover image', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'use_featured_image'    => _x( 'Use as cover image', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'archives'              => _x( 'Booking List archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', 'jugal-holidays' ),
        'insert_into_item'      => _x( 'Insert into package', 'Overrides the “Insert into post”/”Insert into page” phrase (used when inserting media into a post). Added in 4.4', 'jugal-holidays' ),
        'uploaded_to_this_item' => _x( 'Uploaded to this package', 'Overrides the “Uploaded to this post”/”Uploaded to this page” phrase (used when viewing media attached to a post). Added in 4.4', 'jugal-holidays' ),
        'filter_items_list'     => _x( 'Filter packages list', 'Screen reader text for the filter links heading on the post type listing screen. Default “Filter posts list”/”Filter pages list”. Added in 4.4', 'jugal-holidays' ),
        'items_list_navigation' => _x( 'Booking List list navigation', 'Screen reader text for the pagination heading on the post type listing screen. Default “Posts list navigation”/”Pages list navigation”. Added in 4.4', 'jugal-holidays' ),
        'items_list'            => _x( 'Booking List list', 'Screen reader text for the items list heading on the post type listing screen. Default “Posts list”/”Pages list”. Added in 4.4', 'jugal-holidays' ),
    );
 
    $args = array(
        'labels'              => $labels,
        'publicly_queryable' => false,
            'hierarchical'        => false,
            'description'         => 'description',
            'taxonomies'          => array(),
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => null,
            'menu_icon'           => 'dashicons-calendar',
            'show_in_nav_menus'   => true,
            'publicly_queryable'  => true,
            'exclude_from_search' => false,
            'has_archive'         => true,
            'query_var'           => true,
            'can_export'          => true,
            'rewrite'             => true,

            'map_meta_cap' => true,
            'capability_type'     => 'post',
            'capabilities' => array(
                'create_posts' => 'do_not_allow', // false < WP 4.5, credit @Ewout
                  'delete_posts'          => 'do_not_allow',
                   'read_posts'   =>'do_not_allow',
                  'delete_published_posts' =>'do_not_allow',

            ),

            'supports'            => array(
                'title',
                'author',
            ),
    );
 
   
    register_post_type( 'booking_list', $args );
    
     unset($args);
    
    //posttype for jugal team
     $labels = array(
        'name'                  => _x( 'Teams', 'Post type general name', 'jugal-holidays' ),
        'singular_name'         => _x( 'Team', 'Post type singular name', 'jugal-holidays' ),
        'menu_name'             => _x( 'Teams', 'Admin Menu text', 'jugal-holidays' ),
        'name_admin_bar'        => _x( 'Team', 'Add New on Toolbar', 'jugal-holidays' ),
        'add_new'               => __( 'Add New', 'jugal-holidays' ),
        'add_new_item'          => __( 'Add New Team', 'jugal-holidays' ),
        'new_item'              => __( 'New Team', 'jugal-holidays' ),
        'edit_item'             => __( 'Edit Team', 'jugal-holidays' ),
        'view_item'             => __( 'View Team', 'jugal-holidays' ),
        'all_items'             => __( 'All Teams', 'jugal-holidays' ),
        'search_items'          => __( 'Search Teams', 'jugal-holidays' ),
        'parent_item_colon'     => __( 'Parent Teams:', 'jugal-holidays' ),
        'not_found'             => __( 'No teams found.', 'jugal-holidays' ),
        'not_found_in_trash'    => __( 'No teams found in Trash.', 'jugal-holidays' ),
        'featured_image'        => _x( 'Team Cover Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'set_featured_image'    => _x( 'Set profile picture', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'remove_featured_image' => _x( 'Remove profile picture', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'use_featured_image'    => _x( 'Use as profile picture', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', 'jugal-holidays' ),
        'archives'              => _x( 'Team archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', 'jugal-holidays' ),
        'insert_into_item'      => _x( 'Insert into team', 'Overrides the “Insert into post”/”Insert into page” phrase (used when inserting media into a post). Added in 4.4', 'jugal-holidays' ),
        'uploaded_to_this_item' => _x( 'Uploaded to this team', 'Overrides the “Uploaded to this post”/”Uploaded to this page” phrase (used when viewing media attached to a post). Added in 4.4', 'jugal-holidays' ),
        'filter_items_list'     => _x( 'Filter teams list', 'Screen reader text for the filter links heading on the post type listing screen. Default “Filter posts list”/”Filter pages list”. Added in 4.4', 'jugal-holidays' ),
        'items_list_navigation' => _x( 'Teams list navigation', 'Screen reader text for the pagination heading on the post type listing screen. Default “Posts list navigation”/”Pages list navigation”. Added in 4.4', 'jugal-holidays' ),
        'items_list'            => _x( 'Teams list', 'Screen reader text for the items list heading on the post type listing screen. Default “Posts list”/”Pages list”. Added in 4.4', 'jugal-holidays' ),
    );
 
    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array( 'slug' => 'team' ),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-businessman',
        'supports'           => array( 'title', 'thumbnail','editor' ),
    );
 
    register_post_type( 'team', $args );

        unset($args);

}
 
add_action( 'init', 'custom_post_type_registration' );
?>