<?php
// hook into the init action and call create_book_taxonomies when it fires
add_action( 'init', 'custom_taxonomy_registration', 0 );


function custom_taxonomy_registration() {
	
	$labels = array(
		'name'                       => _x( 'Package Types', 'taxonomy general name', 'jugal-holidays' ),
		'singular_name'              => _x( 'Package Type', 'taxonomy singular name', 'jugal-holidays' ),
		'search_items'               => __( 'Search Package Types', 'jugal-holidays' ),
		'popular_items'              => __( 'Popular Package Types', 'jugal-holidays' ),
		'all_items'                  => __( 'All Package Types', 'jugal-holidays' ),
		'parent_item'                => null,
		'parent_item_colon'          => null,
		'edit_item'                  => __( 'Edit Package Type', 'jugal-holidays' ),
		'update_item'                => __( 'Update Package Type', 'jugal-holidays' ),
		'add_new_item'               => __( 'Add New Package Type', 'jugal-holidays' ),
		'new_item_name'              => __( 'New Package Type Name', 'jugal-holidays' ),
		'separate_items_with_commas' => __( 'Separate package types with commas', 'jugal-holidays' ),
		'add_or_remove_items'        => __( 'Add or remove package types', 'jugal-holidays' ),
		'choose_from_most_used'      => __( 'Choose from the most used package types', 'jugal-holidays' ),
		'not_found'                  => __( 'No package types found.', 'jugal-holidays' ),
		'menu_name'                  => __( 'Package Types', 'jugal-holidays' ),
	);

	$args = array(
		'hierarchical'          => true,
		'labels'                => $labels,
		'show_ui'               => true,
		'show_admin_column'     => true,
		'update_count_callback' => '_update_post_term_count',
		'query_var'             => true,
		'rewrite'               => array( 'slug' => 'package_type' ),
	);

	register_taxonomy( 'package_type', 'package', $args );
}
?>