<?php get_header(); 
// $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
$term = get_queried_object();
$image = get_field('image', $term);
$description = get_field('taxonomy_description', $term);
?>

<!-- section banner starts -->
<section class="banner page-banner" style="background-image: url(<?php echo $image['url']; ?>)">
	<div class="tc-wrapper">
		<h1 class="banner-title"><?php echo $term->name ?></h1>
		<a href="<?php echo home_url(); ?>/enquiry-form" class="btn-one">Enquiry Now</a>
	</div>
</section>
<!-- section banner ends -->
<div class="category-overview sp-tb">
	<div class="tc-wrapper">
		<div class="overview-inner">
			<?php echo term_description(); ?>
		</div>
	</div>
</div>
<section class="category-wrapper sp-t sp-b">
	<div class="tc-wrapper">
		<div class="category-filter">
			<div class="row">
				<div class="font col-lg-7 col-md-6">
					<h3 class="category-title">Package Type: <?php echo $term->name ?><span> (<?php echo $term->count;?>)</span> </h3>
				</div>
				<div class="col-lg-5 col-md-6">
					<ul class="cat-title-r">
						<li>
							<div class="category-sort sorter">
								Sort By 
								<select id = "sort" name="sort_trip">
									<option value=''>Select Item</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='popular_trip'){echo 'selected';}?> value="popular_trip">Popularity</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='recent'){echo 'selected';}?> value="recent" >Recent</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='trending'){echo 'selected';}?> value="trending">Trending</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='adventure_trip'){echo 'selected';}?> value="adventure_trip">Adventure</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='best_offer'){echo 'selected';}?> value="best_offer">Best Sales</option>
								</select>
							</div>
						</li>
						<li>
							<div class="sort">
								<ul class="nav">
									<li class="nav-item">
										<a class="nav-link link-secondary active" data-bs-toggle="tab" data-bs-target="#list" href="#">
											<i class="fa fa-list"></i>
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link link-secondary" data-bs-toggle="tab" data-bs-target="#grid" href="#">
											<i class="fa fa-th"></i>
										</a>
									</li>
								</ul>
							</div>
						</li>
					</ul>
				</div>
			</div>
		</div>
		<?php 
		if(have_posts()){
			global $wp_query;
			if(isset($_GET['sort'])){
				$sort = $_GET['sort'];
				if($sort=='recent'){
					$order_by = 'publish_date';
					$order = 'ASC';
					$sort_key = '';
				}else{
					$order_by = 'meta_value';
					$order = 'ASC';
					$sort_key =$sort;
				}
			}
			?>

			<div class="tab-content page-content" id="imgTabContent">
				<!-- //list view -->
				<div class="tab-pane fade show active" id="list" role="tabpanel" aria-labelledby="list-tab">
						<?php
					// Get the current page number
					$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
					$per_page = 9;

					$argsf = array(
						'post_type'      => 'package',
						'posts_per_page' => $per_page,
						'paged'          => $paged,
						'tax_query'      => array(
							array(
								'taxonomy' => $term->taxonomy,
								'field'    => 'slug',
								'terms'    => $term->slug,
							),
						),
					);

					// Sorting logic
					if (isset($_GET['sort'])) {
						$argsf['meta_key'] = $sort_key;
						$argsf['orderby']  = $order_by;
						$argsf['order']    = $order;
					}

					$queryf = new WP_Query($argsf);

					if ($queryf->have_posts()) :
						while ($queryf->have_posts()) : $queryf->the_post();
							$post_id1 = get_the_ID();
							$trending1 = get_field('trending');
							$package_month1 = get_field('package_of_the_month');
							$popular1 = get_field('popular_trip');
							$adventure1 = get_field('adventure_trip');
							$best_offer1 = get_field('best_offer');
							$price1 = get_field('price');
							$duration1 = get_field('duration');
							$overview1 = get_field('overview');
							?>
							<div class="category-details mt">
								<div class="row">
									<div class="col-lg-4">
										<div class="cat-img">
											<a class="imagewrap" href="<?php the_permalink($post_id1); ?>">
												<h2 class="title-tour"><?php the_title(); ?></h2>
												<img src="<?php echo get_the_post_thumbnail_url($post_id1); ?>" alt="Featured Image">
											</a>
										</div>
									</div>
									<div class="col-lg-5 col-md-6">
										<div class="category-description">
											<div class="category-info">
												<p>
													<?php 
													if (!empty($overview1)) { 
														echo wp_trim_words($overview1, 35); 
													} 
													if (str_word_count($overview1) > 35) { ?>
														<a href="<?php the_permalink($post_id1); ?>">Read More</a>
													<?php } ?>
												</p>
											</div>
											<h4>Features</h4>
											<ul>
												<li>
													<i class="fa-solid fa-location-dot"></i>
													<h6>Destination: </h6><span><?php echo get_field('destination') ?: 'N/A'; ?></span>
												</li>
												<li>
													<i class="fa-solid fa-mountain"></i>
													<h6>Altitude: </h6><span><?php echo get_field('altitude') ?: 'N/A'; ?></span>
												</li>
												<li>
													<i class="fa-solid fa-heart-pulse"></i>
													<h6>Fitness Level: </h6><span><?php echo get_field('fitness_level') ?: 'N/A'; ?></span>
												</li>
											</ul>
										</div>
									</div>
									<div class="col-lg-3 col-md-6 d-flex">
										<div class="price-duration w-100">
											<div class="pricetag">
												<span>For Price</span>
												<h3>Enquiry Now</h3>
											</div>
											<div class="duration">
												<h6><i class="fa-solid fa-calendar-days"></i> Duration: <?php echo $duration1 ?: 'N/A'; ?></h6>
											</div>
											<a href="<?php the_permalink($post_id1); ?>" class="btn-one">View Detail</a>
										</div>
									</div>
								</div>
							</div>
						<?php endwhile; ?>
						<div class="pagination mt justify-content-end">
							<?php
								echo paginate_links(array(
									'format'    => '?paged=%#%',
									'total'     => $queryf->max_num_pages,
									'current'   => $paged,
									'type'      => 'plain',
									'prev_text' => '<<',
									'next_text' => '>>',
								));
							?>
							<form>
								<?php if (!empty($_GET['cat'])) { ?>
									<input type="hidden" name="cat" value="<?php echo esc_attr($_GET['cat']); ?>">
								<?php } ?>
								<input id="inputType" type="number" min="1" max="<?php echo $queryf->max_num_pages; ?>" name="paged" value="">
								<button type="submit" id="submit">Go to page <i class="icon-chevron-right"></i></button>
							</form>
						</div>
						<?php
					endif;
					// Restore original Post Data
					wp_reset_postdata();
					?>
				</div>

					<!-- //grid view -->

					<div class="tab-pane fade " id="grid" role="tabpanel" aria-labelledby="grid-tab">
							<div class="row">
									<?php
					// Get the current page number
					$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
					$per_page = 9;

					$argsf = array(
						'post_type'      => 'package',
						'posts_per_page' => $per_page,
						'paged'          => $paged,
						'tax_query'      => array(
							array(
								'taxonomy' => $term->taxonomy,
								'field'    => 'slug',
								'terms'    => $term->slug,
							),
						),
					);

					// Sorting logic
					if (isset($_GET['sort'])) {
						$argsf['meta_key'] = $sort_key;
						$argsf['orderby']  = $order_by;
						$argsf['order']    = $order;
					}

					$queryf = new WP_Query($argsf);

					if ($queryf->have_posts()) :
						while ($queryf->have_posts()) : $queryf->the_post();
							$post_id1 = get_the_ID();
							$trending1 = get_field('trending');
							$package_month1 = get_field('package_of_the_month');
							$popular1 = get_field('popular_trip');
							$adventure1 = get_field('adventure_trip');
							$best_offer1 = get_field('best_offer');
							$price1 = get_field('price');
							$duration1 = get_field('duration');
							$overview1 = get_field('overview');
							?>

									<div class="col-lg-4 col-md-6 col-sm-6 mt d-flex">
										<div class="card3">
											<a href="<?php the_permalink(); ?>">
											<div class="image">
												<img src="<?php echo get_the_post_thumbnail_url() ?>" class="img-fluid" alt="image">
											</div>
											<div class="text">
												<div class="destination">
													<i class="fa-solid fa-location-dot"></i>
													<span><?php if(!empty($destination)){ echo $destination; }else{ echo 'Destination N/A'; } ?></span>
												</div>
												<h5><?php the_title(); ?></h5>
												<ul class="d-flex">
													<li>
														<i class="fa-regular fa-calendar-days"></i>
														<span><?php if(!empty($duration)){ echo $duration; }else{ echo 'Duration N/A'; } ?></span>
													</li>
													<li>
														<i class="fa-regular fa-user"></i>
														<span><?php if(!empty($group)){ echo $group; }else{ echo 'Group N/A'; } ?></span>
													</li>
												</ul>
												<div class="txt-ft d-flex">
													<div class="price">
														<span>For Price</span><h6>Enquiry Now</h6>
													</div>
													<div class="btn-two">View Details</div>
												</div>
											</div>
											</a>
										</div>
									</div>
								<?php endwhile; ?>
						<div class="pagination mt justify-content-end">
							<?php
								echo paginate_links(array(
									'format'    => '?paged=%#%',
									'total'     => $queryf->max_num_pages,
									'current'   => $paged,
									'type'      => 'plain',
									'prev_text' => '<<',
									'next_text' => '>>',
								));
							?>
							<form>
								<?php if (!empty($_GET['cat'])) { ?>
									<input type="hidden" name="cat" value="<?php echo esc_attr($_GET['cat']); ?>">
								<?php } ?>
								<input id="inputType" type="number" min="1" max="<?php echo $queryf->max_num_pages; ?>" name="paged" value="">
								<button type="submit" id="submit">Go to page <i class="icon-chevron-right"></i></button>
							</form>
						</div>
						<?php
					endif;
					// Restore original Post Data
					wp_reset_postdata();
					?>
						</div>
				</div>
			</div>
			<?php
		}
		?>

	</div>
<!-- 	</div> -->
</section>
<!--=====Blog Section=====-->
<section class="blogs cat-blog bg-blue sp-tb">
	<div class="tc-wrapper">
		<div class="section-heading text-center">
			<span>Travel With Us</span>
			<h2>Latest From Blogs</h2>
		</div>
		<div class="row">
			<?php 
			$args6 = array(
				'post_type' => 'post',
				'taxonomy' => 'category',
				'term' => 'blog',
				'posts_per_page' => 3,
			);

			$query6 = new WP_Query($args6);
			if($query6->have_posts()){
				while($query6->have_posts()){
					$query6->the_post();
					$post_id6 = get_the_ID();
					$post_title6 = get_the_title($post_id6);
					$post_content6 = get_the_content($post_id6);
					$post_image6 = get_the_post_thumbnail_url($post_id6);
					$post_date6 = get_the_date('F j, Y',$post_id6); 
					?>
					<div class="col-lg-4 col-md-6 col-sm-6 mt">
						<div class="blog-list">
							<div class="image">
								<a href="<?php the_permalink(); ?>"><img src="<?php echo $post_image6; ?>" alt="Jugal Holidays"></a>
							</div>
							<div class="blog-det">
								<h4><a href="<?php the_permalink($post_id6);?>"><?php echo $post_title6;?></a></h4>
								<ul class="date-cat">
									<li class="date"><span><?php echo $post_date6;?></span></li>
								</ul>
								<div class="description">
									<?php echo wp_trim_words( $post_content6,  14 );?>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
			}
			?>

		</div>
	</div>
</section>
<!--=====End Blog Section=====-->
<?php get_footer(); ?>