<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Jugal_Holidays
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="breadcrumbs">
        <div class="tc-wrapper">
            <h3><?php the_title(); ?></h3>
        </div>
    </div>
    
	<?php jugal_holidays_post_thumbnail(); ?>

	<div class="tc-wrapper">
	    <div class="entry-content">
		<?php
		the_content();

		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'jugal-holidays' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->
	</div>

	<?php if ( get_edit_post_link() ) : ?>
		<footer class="entry-footer">
			<?php
			edit_post_link(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Edit <span class="screen-reader-text">%s</span>', 'jugal-holidays' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				),
				'<span class="edit-link">',
				'</span>'
			);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->
