--TEST--
Test for bug #2063: ArrayObject storage elements not viewable in PhpStorm
--SKIPIF--
<?php
require __DIR__ . '/../utils.inc';
check_reqs('dbgp');
?>
--FILE--
<?php
require 'dbgp/dbgpclient.php';
$filename = dirname(__FILE__) . '/bug02063.inc';

$commands = array(
	'step_into',
	'breakpoint_set -t line -n 4',
	'run',
	'property_get -n $permissions',
	'property_get -n $permissions->storage',
	'property_get -n $permissions->storage[0]',
	'detach',
);

dbgpRunFile( $filename, $commands );
?>
--EXPECTF--
<?xml version="1.0" encoding="iso-8859-1"?>
<init xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" fileuri="file://bug02063.inc" language="PHP" xdebug:language_version="" protocol_version="1.0" appid=""><engine version=""><![CDATA[Xdebug]]></engine><author><![CDATA[Derick Rethans]]></author><url><![CDATA[https://xdebug.org]]></url><copyright><![CDATA[Copyright (c) 2002-2099 by Derick Rethans]]></copyright></init>

-> step_into -i 1
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="step_into" transaction_id="1" status="break" reason="ok"><xdebug:message filename="file://bug02063.inc" lineno="2"></xdebug:message></response>

-> breakpoint_set -i 2 -t line -n 4
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="breakpoint_set" transaction_id="2" id=""></response>

-> run -i 3
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="run" transaction_id="3" status="break" reason="ok"><xdebug:message filename="file://bug02063.inc" lineno="4"></xdebug:message></response>

-> property_get -i 4 -n $permissions
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="property_get" transaction_id="4"><property name="$permissions" fullname="$permissions" type="object" classname="ArrayObject" children="1" numchildren="1" page="0" pagesize="32"><property name="storage" fullname="$permissions-&gt;storage" facet="private" type="array" children="1" numchildren="1"></property></property></response>

-> property_get -i 5 -n $permissions->storage
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="property_get" transaction_id="5"><property name="$permissions-&gt;storage" fullname="$permissions-&gt;storage" type="array" children="1" numchildren="1" page="0" pagesize="32"><property name="0" fullname="$permissions-&gt;storage[0]" type="int"><![CDATA[1]]></property></property></response>

-> property_get -i 6 -n $permissions->storage[0]
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="property_get" transaction_id="6"><property name="$permissions-&gt;storage[0]" fullname="$permissions-&gt;storage[0]" type="int"><![CDATA[1]]></property></response>

-> detach -i 7
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="detach" transaction_id="7" status="stopping" reason="ok"></response>
