<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Jugal_Holidays
 */

?>

</div><!-- #content -->
<!-- =====section trip-plan starts===== -->
<section class="trip-plan" style="background-image: url(<?php echo home_url(); ?>/wp-content/uploads/2023/12/34bc9fa9-b4cd-4089-848f-a8c6eabc2af2.jpeg)">
	<div class="tc-wrapper">
		<div class="trip-plan-content">
			<h4>Decide Before You Travel</h4>
			<p style="font-size: 50px;">Planning for the Best Vacation this Season?</p>
			<!--<p>You are most Welcome to Plan and Book Amazing tours and Customized Holidays</p>-->
			<!--<a href="<?php echo home_url(); ?>/plan-trip" class="btn-one">Plan Your Trip</a>-->
		</div>
		<?php $planningGal = get_field('planning_vacation',40) ?>
		<!--<pre><?php echo print_r($planningGal)  ?></pre>-->
        <div class="slider-content">
        		<div class="owl-carousel owl-theme member-slide">
        		    <?php foreach($planningGal as $gallery){ ?>
        			<div class="item">
        				 <img src="<?php echo $gallery['full_image_url'] ?>" alt="image">  
        			</div>
        		<?php } ?>
        		</div>
        </div>
	</div>
</section>
<!-- =====section trip plan ends===== -->
<footer class="footer">
	<div class="footer-top">
		<div class="container-fluid">
			<div class="row">
				<div class="col-lg-3 col-md-6 col-sm-6">
					<div class="footer-inner ft-link">
						<h3 class="ft-title">Top Categories</h3>
						 <img src="<?php echo home_url('/wp-content/uploads/2019/08/Visit-Nepal-2020-Logo.jpg'); ?>" alt="visit-nepal-logo"> 
						<ul class="footer-activity">
							<li>
								<a href="<?php echo home_url(); ?>/package_type/tour-in-nepal">
									Tours in Nepal
								</a>
							</li>
							<li>
								<a href="<?php echo home_url(); ?>/package_type/trekking-and-hiking">
									Trekking and Hiking
								</a>
							</li>
							<li>
								<a href="<?php echo home_url(); ?>/package_type/climbing-and-expedition">
									Climbing and Expedition
								</a>
							</li>
							<li>
								<a href="<?php echo home_url(); ?>/package_type/heli-tour">
									Heli Tours
								</a>
							</li>
							<li>
								<a href="<?php echo home_url(); ?>/package_type/adventure-sports">
									Adventure Sports
								</a>
							</li>
						</ul>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 col-sm-6">
					<div class="footer-inner ft-link">
						<h3 class="ft-title">Popular Trips</h3>
						<ul class="footer-activity">
							<?php

							$argsf = array(
								'post_type' =>'package',
								 'tax_query' => array(
        array(
            'taxonomy' => 'package_type',
            'field'    => 'slug',
            'terms'    => 'Popular Trips',
            ),
        )

							);
							$queryf = new WP_Query($argsf);

							if($queryf->have_posts()){

								while($queryf->have_posts()){
									$queryf->the_post();


										?>

										<li><a href="<?php the_permalink() ?>"><?php the_title() ?></a></li>
										<?php
								}
								wp_reset_postdata();
							}
							?>

						</ul>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 col-sm-6">
					<div class="footer-inner ft-link">
						<h3 class="ft-title">Useful Links</h3>
						<ul class="footer-menu">
							<li><a href="<?php echo esc_url( home_url());?>">Home</a></li>
							
							<li><a href="<?php echo esc_url( home_url('/package'));?>">Packages</a></li>
							<li><a href="<?php echo esc_url( home_url('/about-us'));?>">About</a></li>
							<li><a href="<?php echo esc_url( home_url('/team'));?>">Our Team</a></li>
							<li><a href="<?php echo esc_url( home_url('/terms'));?>">Terms &amp; Conditions</a></li>
						</ul>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 col-sm-6">
					<div class="footer-inner">
						<h3 class="ft-title">Contact Us</h3>
						<ul class="footer-contact">
							<li class="flaticon-home">
								<a href="https://www.google.com/maps/place/Jugal+Holidays+Pvt.+Ltd./@27.7132347,85.3107326,17z/data=!3m1!4b1!4m5!3m4!1s0x39eb191fe2fdcd7b:0x55854fb2712e670a!8m2!3d27.7132259!4d85.3129207" target="_blank">
									<?php $my_option = get_option( 'jugal_framework' );
									echo $my_option['contact_address'];
									?>
								</a>
							</li>
							<li class="flaticon-old-typical-phone"><?php 
							$phones = $my_option['contact'];
							if(!empty($phones)){
								$cnt = count($phones);
								$i=1;
								foreach($phones as $phone){

									if($i==1){
										?>
										<a href="tel:<?php echo $phone['contact_number'];?>" target="_blank"><?php echo $phone['contact_number'];?></a>
										<?php 
									}
									if($i==2){
										?>
										,<br/><a href="tel:<?php echo $phone['contact_number'];?>" target="_blank"><?php echo $phone['contact_number'];?></a> 

										<?php
									}
									if($i==3){
										?>
										,<br/><a href="tel:<?php echo $phone['contact_number'];?>" target="_blank"><?php echo $phone['contact_number'];?></a> 

										<?php
									}
									$i++;
								}
							}
							?></li>
							<li class="flaticon-close-envelope"><?php
							$emails = $my_option['cont_email'];
							if(!empty($emails)){
								$cnt = count($emails);
								$i=1;
								foreach($emails as $email){

									if($i==1){
										?>
										<a href="mailto:<?php echo $email['contact_email'];?>" target="_blank"><?php echo $email['contact_email'];?></a>
										<?php 
									}
									if($i==2){
										?>
										<br/><a href="mailto:<?php echo $email['contact_email'];?>" target="_blank"><?php echo $email['contact_email'];?></a> 

										<?php
									}
									$i++;
								}
							}
							?></li>
						</ul>
					</div>
				</div>
				<div class="col-lg-5 col-md-4">
					<div class="footer-payment footer-member">
						<h5>We are Members of</h5>
						<ul>
							<li><a href="http://tourismdepartment.gov.np/" target="_blank"><img src="<?php echo home_url('/wp-content/uploads/2024/02/nep-gov.jpg'); ?>" alt="nepal-goverment"></a></li>
							<li><a href="http://www.nepalmountaineering.org/" target="_blank"><img src="<?php echo home_url('/wp-content/uploads/2024/02/nma.jpg'); ?>" alt="nmb"></a></li>
							<li><a href="https://www.welcomenepal.com/" target="_blank"><img src="<?php echo home_url('/wp-content/uploads/2024/02/ntb.jpg'); ?>" alt="nepal-tourism-board"></a></li>
							<li><a href="https://natta.org.np/" target="_blank"><img src="<?php echo home_url('/wp-content/uploads/2024/02/natta.jpg'); ?>" alt="natta"></a></li>
							<li><a href="https://www.pata.org/" target="_blank"><img src="<?php echo home_url('/wp-content/uploads/2024/02/pata.png'); ?>" alt="pata"></a></li>
							<li><a href="http://www.taan.org.np/" target="_blank"><img src="<?php echo home_url('/wp-content/uploads/2019/04/taan.jpg'); ?>" alt="taan"></a></li>

						</ul>
					</div>
				</div>
				<div class="col-lg-4 col-md-4">
					<div class="footer-payment footer-newsletter">
						<h5>Subscribe To Our Newsletter</h5>
						<div class="newsletter-inner">
							<div class="input-email">
								<form>
									<div class="input-group">
										<input type="email" name="email" placeholder="Enter Your Email">
										<button class="btnsub">Subscribe</button>
									</div>
								</form>
								
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-md-4">
					<div class="footer-payment">
						<h5>We accept</h5>
						<ul>
							<li><img src="<?php echo home_url('/wp-content/uploads/2019/01/maestro.png'); ?>" alt="maestro"></li>
							<li><img src="<?php echo home_url('/wp-content/uploads/2019/01/visa.png'); ?>" alt="visa"></li>
							<li><img src="<?php echo home_url('/wp-content/uploads/2019/01/mastercard.png'); ?>" alt="mastercard"></li>
							<li><img src="<?php echo home_url('/wp-content/uploads/2019/01/maestro.png'); ?>" alt="maestro"></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="footer-bottom">
		<div class="tc-wrapper">
			<div class="row">
				<div class="col-12">
					<div class="ft-contact">
						<div class="ft-submenu">
							<ul>
								<li>
									<a href="<?php echo home_url(); ?>/about-us">
										About Us
									</a>
								</li>
								<li>
									<a href="<?php echo home_url(); ?>/blog">
										Blog
									</a>
								</li>
								<li>
									<a href="<?php echo home_url(); ?>/team">
										Our Team
									</a>
								</li>
								<li>
									<a href="<?php echo home_url(); ?>/terms-and-conditions">
										Terms
									</a>
								</li>
								<li>
									<a href="<?php echo home_url(); ?>/contact-us">
										Contact Us
									</a>
								</li>
							</ul>
						</div>
						<div class="ft-socialmedia">
							<span>
								Follow Us: &nbsp
							</span>
							<ul class="d-none">
								<li>
									<a href="#">
										<i class="fab fa-facebook-f"></i>
									</a>
								</li>
								<li>
									<a href="#">
										<i class="fab fa-twitter"></i>
									</a>
								</li>
								<li>
									<a href="#">
										<i class="fab fa-instagram"></i>
									</a>
								</li>
							</ul>
							<ul class="social-icon">
								<?php if(!empty($my_option['facebook'])){
									?>
									<li><a href="<?php echo $my_option['facebook']; ?>" aria-label="Facebook" class="face" target="_blank">
										<i class="fab fa-facebook-f"></i>
									</a></li>
									<?php
								} ?>
								<?php if(!empty($my_option['twitter'])){
									?>
									<li><a href="<?php echo $my_option['twitter'];?>" aria-label="Twitter" class="twit" target="_blank"><i class="fab fa-twitter"></i></a></li>
									<?php 
								}
								if(!empty($my_option['instagram'])){
									?>
									<li><a href="<?php echo $my_option['instagram'];?>" aria-label="Instagram" class="insta" target="_blank"><i class="fab fa-instagram"></i></a></li>
									<?php 
								}
								if(!empty($my_option['googleplus'])){
									?>
									<li><a  href="<?php echo $my_option['googleplus'];?>" aria-label="Googleplus" class="goog" target="_blank"><i class="fab fa-google-plus-g"></i></a></li>
									<?php
								}
								?>
							</ul>
						</div>
					</div>
					<div class="copyright">
						© <?php echo date('Y');?> Jugal Holidays. All Rights Reserved. Developed &amp; Maintained by: <a href="https://icebergtechnepal.com" target="_blank">Iceberg Technology</a>						</div>
					</div>
				</div>
			</div>
		</div>
	</footer>
	<!-- =====section footer ends===== -->
	<div id="scroll-top">
		<a href="#">
			<i class="fas fa-chevron-up"></i>
		</a>
	</div>
	<!-- =====scroll top ends===== -->
	
</div><!-- #page -->

<?php wp_footer(); ?>
<script
  src="https://code.jquery.com/jquery-3.7.1.js"
  integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
  crossorigin="anonymous"></script>
<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/6347d31754f06e12d899ef49/1gf8915l0';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->

</body>
</html>
