<?php
/**
 * Jugal Holidays functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Jugal_Holidays
 */

if ( ! function_exists( 'jugal_holidays_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function jugal_holidays_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Jugal Holidays, use a find and replace
		 * to change 'jugal-holidays' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'jugal-holidays', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'jugal-holidays' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'jugal_holidays_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'jugal_holidays_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function jugal_holidays_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'jugal_holidays_content_width', 640 );
}
add_action( 'after_setup_theme', 'jugal_holidays_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function jugal_holidays_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'jugal-holidays' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'jugal-holidays' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'jugal_holidays_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function jugal_holidays_scripts() {
	wp_enqueue_style( 'jugal-holidays-style', get_stylesheet_uri() );

	wp_enqueue_script( 'jugal-holidays-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );
//  wp_enqueue_style( 'fontgoogleapis', "https://fonts.googleapis.com/css?family=Muli|Roboto&display=swap");
// 	wp_enqueue_style( 'fontgoogleapiss', "https://fonts.googleapis.com/css?family=Montserrat|Handlee&display=swap");
	/* Bootstrap min CSS */
	wp_enqueue_style('bootstrap-new', "https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css");
   
//     wp_enqueue_style( 'bootstrap-grid', get_template_directory_uri() . '/css/bootstrap-grid.min.css', array(), '1.1', 'all');

    /*Flat Icon CSS*/
    wp_enqueue_style( 'Flat icon', get_template_directory_uri() . '/fonts/flaticon.css', array(), '1.1', 'all');

    /* Owl Carousels CSS */
    wp_enqueue_style( 'owl.carousel', "https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css", array(), '1.1', 'all');
    wp_enqueue_style( 'owl.theme', "https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css", array(), '1.1', 'all');
    
    /* Datetime Pciker CSS */
    wp_enqueue_style( 'date-picker', get_template_directory_uri() . '/plugin/datepicker-master/dist/datepicker.css', array(), '1.1', 'all');

    /* Light Slider min CSS */
    wp_enqueue_style( 'lightslider', "https://cdnjs.cloudflare.com/ajax/libs/lightslider/1.1.6/css/lightslider.min.css", array(), '1.1', 'all');

	/*Pop-up Font CSS*/
	wp_enqueue_style( 'popup-css', get_template_directory_uri() . '/plugin/magnific-popup/dist/magnific-popup.css', array(), '1.1', 'all');

	 /* Fancybox CSS */
    wp_enqueue_style( 'fancybox',"https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css", array(), '1.1', 'all');
    /* Custom CSS */
    wp_enqueue_style( 'travigo', get_template_directory_uri() . '/css/jugal.css', array(), '1.1', 'all');
	wp_enqueue_style( 'fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css');
    /* Responsive Fix CSS */
    wp_enqueue_style( 'responsive', get_template_directory_uri() . '/css/responsive-fix.css', array(), '1.1', 'all');
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.css', array(), '1.1', 'all');	

	/*jQuery JS*/
	wp_enqueue_script('jQuery');	
	wp_enqueue_script('jquery1',"https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js",array(), true); 
	/*Bootstrap JS*/
	wp_enqueue_script( 'bootstrap-js-new', "https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js", array (), 1.1, true);
//     wp_enqueue_script( 'bootstrap-js', "https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js", array (), 1.1, true);
	/*Popup JS*/
	wp_enqueue_script( 'animate', get_template_directory_uri() . '/plugin/magnific-popup/dist/jquery.magnific-popup.js', array(), '1.1', 'all');

	

    /*Datetime Picker JS*/
    wp_enqueue_script( 'datetime-picker-js', get_template_directory_uri() . '/plugin/datepicker-master/dist/datepicker.js', array (), 1.1, true);

    /*Owl Carousel JS*/
    wp_enqueue_script( 'owl-js', get_template_directory_uri() . '/plugin/OwlCarousel/dist/owl.carousel.min.js', array (), 1.1, true);

    /*Light Slider JS*/
    wp_enqueue_script( 'lightslider-js', get_template_directory_uri() . '/plugin/lightslider-master/src/js/lightslider.js', array (), 1.1, true);

    /*Fancybox JS*/
    wp_enqueue_script( 'fancybox-js', get_template_directory_uri() . '/plugin/fancybox/dist/jquery.fancybox.min.js', array (), 1.1, true);
    
    wp_enqueue_script( 'custom-js', get_template_directory_uri() . '/js/custom.js', array(),false, true );
    
    wp_enqueue_script('gogle_map','https://maps.googleapis.com/maps/api/js?key=AIzaSyAdIau4wuu7-3wuunf3cM9w5xdk_Wzyvc4',array(),true);

	
	


	wp_enqueue_script( 'jugal-holidays-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}
add_action( 'wp_enqueue_scripts', 'jugal_holidays_scripts' );

// paginatinon and enqueue category
function ajax_enqueue(){
    wp_register_script( "package-type_script", get_template_directory_uri().'/js/package_type.js', array('jquery') );
    wp_localize_script( 'package-type_script', 'package_type', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));

    wp_enqueue_script( 'jquery' );
    wp_enqueue_script( 'package-type_script');
}

add_action('init','ajax_enqueue');

add_action("wp_ajax_package_type_paginate", "package_type_paginate");
add_action("wp_ajax_nopriv_package_type_paginate", "package_type_paginate");

function package_type_paginate(){
    if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
        $page_number = $_REQUEST['page_number'];
        $post_per_page=$_REQUEST['post_per_page'];
        $disp_typ = $_REQUEST['disp_typ'];
        $post_typ='package';
        $term_slug=$_REQUEST['term_slug'];
        $result=array();
        $currentpage=($page_number-1)*$post_per_page;

        $num_of_page='';
        $temp_array=array();
       if(isset($_GET['sort'])){
					$sort = $_GET['sort'];
						if($sort=='recent'){
							$order_by = 'publish_date';
							$order = 'ASC';
							$sort_key = '';
						}else{
							$order_by = 'meta_value';
							$order = 'ASC';
							$sort_key =$sort;
						}
			}else{
				$order_by ='';
				$order = '';
				$sort_key = '';
			}


        $args2=array(
            'post_type'=>$post_typ,
            'tax_query' => array(
                array(
                    'taxonomy' => 'package_type',
                    'field'    => 'slug',
                    'terms'    => $term_slug,
                ),
            ),
            'meta_key'   => $sort_key,
			'orderby'    => $order_by,
			'order'		=>	$order,
            'paged'=>$page_number,
            'posts_per_page'=>$post_per_page,
            'offset'=>$currentpage,

        );


        $query2=new WP_Query($args2);
        if($query2->have_posts()):

            while($query2->have_posts()){
                $query2->the_post();
                $post_id=get_the_ID();
                $title=get_the_title();
                $content=get_field('overview',$post_id);

                $feature_img=get_the_post_thumbnail_url();
                
                $price=get_field('price',$post_id);
                
                $duration=get_field('duration',$post_id);
                $group_size = get_field('group_size', $post_id);
                $accomodation = get_field('accomodation', $post_id);
                $permalinktab = get_the_permalink($post_id);
                $meal= get_field('meal',$post_id);

                array_push($temp_array,array(
                	'title'=>$title,
                    'content'=>$content?$content:'N/A',
                    'feature_img'=>$feature_img,
                    
                    'price'=>$price?$price:'N/A',
                    'permalinktab'=>$permalinktab,
                    'duration'=>$duration?$duration:'N/A',
                    'group_size'=>$group_size?$group_size:'N/A',
                    'meal' => $meal?$meal:'N/A',
                    'accomodation'=>$accomodation?$accomodation:'N/A',
                ));


            }
            wp_reset_postdata();

            $num_of_page=$query2->max_num_pages;



        endif;

        array_push($result,$temp_array,array(
            'num_of_page'=>$num_of_page,
            'page_number'=> $page_number,
            'post_per_page'=>$post_per_page,
            'term_slug'=>$term_slug,
            'disp_typ'=>$disp_typ,
        ));
        if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            $result = json_encode($result);
            echo $result;

        } else {
            header("Location: " . $_SERVER["HTTP_REFERER"]);
        }

        die();
    }

}


/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

//custom post type call

require_once get_template_directory().'/inc/custom_posttype.php';

//custom taxonomy call 

require_once get_template_directory().'/inc/custom_taxonomy.php';

//custom admin functions call
require_once get_template_directory().'/inc/admin_functions.php'; 




/**
** automatically select the parent item in the taxonomy after selection of the child term
**/
add_action('save_post', 'assign_parent_terms', 10, 2);

function assign_parent_terms($post_id, $post){

    if($post->post_type != 'package')
        return $post_id;

    // get all assigned terms   
    $terms = wp_get_post_terms($post_id, 'package_type' );
    foreach($terms as $term){
        while($term->parent != 0 && !has_term( $term->parent, 'package_type', $post )){
            // move upward until we get to 0 level terms
            wp_set_post_terms($post_id, array($term->parent), 'package_type', true);
            $term = get_term($term->parent, 'package_type');
        }
    }
}



//codestar implement
require_once get_template_directory().'/inc/themeoption.php';


//booking 
require_once get_template_directory().'/inc/booking_functions.php';

//acf api for googlemap
function my_acf_google_map_api( $api ){
	
	$api['key'] = 'AIzaSyAdIau4wuu7-3wuunf3cM9w5xdk_Wzyvc4';
	
	return $api;
	
}

add_filter('acf/fields/google_map/api', 'my_acf_google_map_api');

// template redirector
function template_chooser( $template ){
    global $wp_query;
    
    if( $wp_query->is_search ){
        return locate_template('search-page.php');  //  redirect 
    } 
    return $template;
}
add_filter( 'template_include', 'template_chooser' );


//search pagination 
// function search_filter($query) {
//   if ( !is_admin() && $query->is_main_query() ) {
//     if ($query->is_search) {
//       $query->set('paged', ( get_query_var('paged') ) ? get_query_var('paged') : 1 );
//       $query->set('posts_per_page',2);
//     }
//   }
// }
// add_filter('pre_get_posts','search_filter');
function add_theme_caps() {
$role_object = get_role( 'editor' );
$role_object->add_cap( 'manage_option');
$role_object->add_cap( 'edit_theme_options' );
	
}
add_action( 'admin_init', 'add_theme_caps');

//Related Posts

function example_cats_related_post() {

    $post_id = get_the_ID();
    $cat_ids = array();
    $categories = get_the_category( $post_id );

    if(!empty($categories) && !is_wp_error($categories)):
        foreach ($categories as $category):
            array_push($cat_ids, $category->term_id);
        endforeach;
    endif;

    $current_post_type = get_post_type($post_id);

    $query_args = array( 
        'category__in'   => $cat_ids,
        'post_type'      => $current_post_type,
        'post__not_in'    => array($post_id),
        'posts_per_page'  => '4',
        'orderby' => 'rand',
     );

    $related_cats_post = new WP_Query( $query_args );

    if($related_cats_post->have_posts()):
         while($related_cats_post->have_posts()): $related_cats_post->the_post(); ?>
           
						<div class="col-lg-12 col-md-4 col-sm-6">
							<div class="row">
								<div class="col-lg-5">
									<a href="<?php the_permalink(); ?>">
										<img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="related-package">
									</a>
								</div>
								<div class="col-lg-7 padd-0">
									<div class="related-package">
										<h3>
											<a href="<?php the_permalink(); ?>">
											<?php the_title(); ?></a>
										</h3>
										<h5 class="d-none">Price: <span>$124</span></h5>
									</div>
								</div>
							</div>
						</div>
                        
        <?php endwhile;

        // Restore original Post Data
        wp_reset_postdata();
     endif;

}
if(isset($_POST['checkout'])){
//   require __DIR__ . '/quality/vendor/autoload.php';
// require __DIR__ . '/quality/payment_request.php';
require __DIR__ . '/hblpay/vendor/autoload.php';
require __DIR__ . '/hblpay/payment_request.php';
//require 'https://jugalholidays.com/wp-content/themes/jugal-holidays/hblpay/payment_request.php';

//require get_template_directory_uri().'/hblpay/vendor/autoload.php';
//require get_template_directory_uri().'/hblpay/payment_request.php';
}
function convertNumber($num = false)
{
    $num = str_replace(array(',', ''), '' , trim($num));
    if(! $num) {
        return false;
    }
    $num = (int) $num;
    $words = array();
    $list1 = array('', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven',
        'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
    );
    $list2 = array('', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety', 'hundred');
    $list3 = array('', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion', 'sextillion', 'septillion',
        'octillion', 'nonillion', 'decillion', 'undecillion', 'duodecillion', 'tredecillion', 'quattuordecillion',
        'quindecillion', 'sexdecillion', 'septendecillion', 'octodecillion', 'novemdecillion', 'vigintillion'
    );
    $num_length = strlen($num);
    $levels = (int) (($num_length + 2) / 3);
    $max_length = $levels * 3;
    $num = substr('00' . $num, -$max_length);
    $num_levels = str_split($num, 3);
    for ($i = 0; $i < count($num_levels); $i++) {
        $levels--;
        $hundreds = (int) ($num_levels[$i] / 100);
        $hundreds = ($hundreds ? ' ' . $list1[$hundreds] . ' hundred' . ( $hundreds == 1 ? '' : '' ) . ' ' : '');
        $tens = (int) ($num_levels[$i] % 100);
        $singles = '';
        if ( $tens < 20 ) {
            $tens = ($tens ? ' and ' . $list1[$tens] . ' ' : '' );
        } elseif ($tens >= 20) {
            $tens = (int)($tens / 10);
            $tens = ' and ' . $list2[$tens] . ' ';
            $singles = (int) ($num_levels[$i] % 10);
            $singles = ' ' . $list1[$singles] . ' ';
        }
        $words[] = $hundreds . $tens . $singles . ( ( $levels && ( int ) ( $num_levels[$i] ) ) ? ' ' . $list3[$levels] . ' ' : '' );
    } //end for loop
    $commas = count($words);
    if ($commas > 1) {
        $commas = $commas - 1;
    }
    $words = implode(' ',  $words);
    $words = preg_replace('/^\s\b(and)/', '', $words );
    $words = trim($words);
    $words = ucfirst($words);
    $words = $words . ".";
    return $words;
} 