<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Jugal_Holidays
 */

?>
<!DOCTYPE HTML>
<html lang = "en">
<html <?php language_attributes(); ?>>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<link rel="profile" href="https://gmpg.org/xfn/11">
<!-- 	<link href="https://fonts.googleapis.com/css?family=Muli|Roboto&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Montserrat|Handlee&display=swap" rel="stylesheet"> -->
	<link href="https://use.fontawesome.com/releases/v5.5.0/css/all.css" rel="stylesheet">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="language" content="English">
	<meta name="revisit-after" content="1 days">
	<meta name="author" content="iceberg Technology">
	<script data-ad-client="ca-pub-9818673900351802" async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>


<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-J4FZQ3WVNR"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-J4FZQ3WVNR');
</script>


	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>	
	<div id="page" class="site">
		<div class="site-header">
			<header class="header">
				<div class="tc-wrapper">
					<div class="row">
						<div class="col-md-5 my-auto">
							<a href="<?php echo home_url(); ?>">
								<div class="logo">
									<img src="<?php echo home_url('/wp-content/uploads/2024/02/logo-2.png'); ?>" alt="Jugal Holidays Pvt. Ltd.">
									<div class="logo-text">
										<span class="logo-title"><?php
										$my_option =get_option( 'jugal_framework' ); 
										echo $my_option['site_title']; ?></span>
										<small class="logo-subtitle">Your Reliable Partner In Nepal</small>
									</div>
								</div>
							</a>
						</div>
						<div class="col-md-7 my-auto">
							<div class="header-info">
								<ul class="header-contact">
									<li class="contact-icon">
										<a href="tel:+9779851008066" aria-label="Phone" class="phone"><i class="fas fa-phone"></i></a>
										<a href="tel:+9779851008066" aria-label="Whatsapp" class="whatsapp"><i class="fab fa-whatsapp"></i> </a>
										<a href="tel:+9779851008066" aria-label="Viber" class="viber"><i class="fab fa-viber"></i> </a>
										<?php 
										$phones = $my_option['contact'];
										if(!empty($phones)){
											$cnt = count($phones);
											$i=1;
											foreach($phones as $phone){
												if($i == 1){
													?>
													<a href="tel:<?php echo $phone['contact_number'];?>"><?php echo $phone['contact_number'];?></a>
													<?php
												}

												$i++;
											}
										}
										?>
									</li>
									<li>
<!-- 										<i class="flaticon-close-envelope"></i> -->
										<i class="fas fa-envelope"></i>
										<?php
										$emails = $my_option['cont_email'];
										if(!empty($emails)){
											$cnt = count($emails);
											$i=1;
											foreach($emails as $email){
												if($i==1){
													?>
													<a href="mailto:<?php echo $email['contact_email'];?>"><?php echo $email['contact_email'];?></a>
													<?php
												}

												$i++;
											}
										}
										?>
									</li>
								</ul>
								<ul class="header-link">
									<li class="trip-link">
										<h5 class="follow-us">Looking for Trip?</h5>
										<a href="<?php echo home_url(); ?>/plan-trip" class="btn-two">Plan A Trip</a>
									</li>
									<li class="header-tripadvisor">
										<div class="trip-advisor">
										<div class="image">
											<img src="<?php echo home_url(); ?>/wp-content/uploads/2024/02/trip.png" class="img-fluid" alt="image">
										</div>
										<div class="advisor">
											<span>Recommended On</span>
											<h6>Trip Advisor</h6>
										</div>
										</div>
									</li>
<!-- 									<li class="social-media d-none">
										<h5 class="follow-us">Follow us:</h5>
										<ul class="social-icon">
											<?php if(!empty($my_option['facebook'])){
												?>
												<li><a target="_blank" href="<?php echo $my_option['facebook']; ?>" class="face">
													<i class="fab fa-facebook-f"></i>
												</a></li>
												<?php
											} ?>
											<?php if(!empty($my_option['twitter'])){
												?>
												<li><a target="_blank" href="<?php echo $my_option['twitter'];?>" class="twit"><i class="fab fa-twitter"></i></a></li>
												<?php 
											}
											if(!empty($my_option['instagram'])){
												?>
												<li><a target="_blank" href="<?php echo $my_option['instagram'];?>" class="insta"><i class="fab fa-instagram"></i></a></li>
												<?php 
											}
											if(!empty($my_option['googleplus'])){
												?>
												<li><a target="_blank" href="<?php echo $my_option['googleplus'];?>" class="goog"><i class="fab fa-google-plus-g"></i></a></li>
												<?php
											}
											?>
										</ul>
									</li> -->
<!-- 									<li class="contact-link d-none">
										<h5 class="follow-us">Get in Touch</h5>
										<a href="#" class="btn-two">Contact Us</a>
									</li> -->
								</ul>
							</div>
						</div>
					</div>
				</div>
			</header>
			<div class="nav-menu">
				<div class="tc-wrapper">
					<?php wp_nav_menu(array('theme_location' => 'menu-1')); ?>
				</div>
			</div>
		</div>

		<div id="content" class="site-content">



