<?php

add_action( 'add_meta_boxes', 'meta_box_add_booking' );
function meta_box_add_booking(){
    add_meta_box( 'booking-status', 'Booking Status', 'booking_status_view', 'booking_list', 'side', 'high' );

    add_meta_box('personal_details','Personal Details','personal_details_view','booking_list','normal','high');

    add_meta_box( 'peopleno', 'People Number', 'peopleno_view', 'booking_list', 'normal', 'high' );

    add_meta_box('trip_details','Trip Details','trip_details_view','booking_list','normal','high');

    add_meta_box( 'startdate', 'Start Date', 'startdate_view', 'booking_list', 'normal', 'high' );
    add_meta_box( 'enddate', 'End Date', 'enddate_view', 'booking_list', 'normal', 'high' );

}
function booking_status_view(){
    require_once get_template_directory() . '/inc/booking_status_view.php';
}


function personal_details_view(){
    require_once get_template_directory() . '/inc/personal_details_view.php';
}

function peopleno_view(){
    require_once get_template_directory() . '/inc/peopleno_view.php';
}

function trip_details_view(){
    require_once get_template_directory() . '/inc/trip_details_view.php';
}

function startdate_view(){
    require_once get_template_directory() . '/inc/startdate_view.php';
}
function enddate_view($post){
    require_once get_template_directory() . '/inc/enddate_view.php';
}

add_action( 'save_post', 'cd_meta_box_save' );
function cd_meta_box_save( $post_id ){
    global $post;
    // Bail if we're doing an auto save
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

    // if our current user can't edit this post, bail
    if( !current_user_can( 'edit_post',$post_id ) ) return;

    if( isset( $_POST['booking_status'] ) ){
        $booking_status = $_POST['booking_status'];
        // var_dump( $booking_status);
        // die();

        update_post_meta( $post_id, 'booking_status', $booking_status, false );
		if($booking_status==1){

        $to=get_field('email',$post_id);
        $subject='Booking Of '.get_the_title($post_id);
        $message='Your Booking have been approved for the further process.We will contact you for other process in your phone or in this email.
        If there is any queries regarding your booking and the trip,Please do contact us. You may contact us through mail and phone.
        e-mail:icebergtechnology@gmail.com
        contact no:9898989898';
       $sender_name='Jugal Holidays';
			$sender_mail='wordpress@jugalholidays.com';
        $headers='From: '. $sender_name .' <'. $sender_mail .'>' . "\r\n";
        $attachment='';
        $approve_sent= wp_mail(  $to, $subject, $message,$headers);
        
    }elseif ($booking_status==2){
        $to=get_field('email',$post_id);
        $subject='Booking Of '.get_the_title($post_id);
        $message='Your Booking have been rejected because of various reason.We will contact you for other process in your phone or in this email.
        If there is any queries regarding your booking and the trip,Please do contact us. You may contact us through mail and phone.
        e-mail:icebergtechnology@gmail.com
        contact no:9898989898';
			$sender_name='Jugal Holidays';
			$sender_mail='wordpress@jugalholidays.com';
        $headers='From: '. $sender_name .' <'. $sender_mail .'>' . "\r\n";
        $attachment='';
        $reject_sent= wp_mail(  $to, $subject, $message,$headers);
      
    }

    }

}

add_action( 'save_post', 'peopleno_save' );
function peopleno_save( $post_id ){
    global $post;
    // Bail if we're doing an auto save
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

    // if our current user can't edit this post, bail
    if( !current_user_can( 'edit_post',$post_id ) ) return;

    if( isset( $_POST['peopleno'] ) ){
        $peopleno = $_POST['peopleno'];


        update_post_meta( $post_id, 'group_size', $peopleno, false );

    }

}

add_action( 'save_post', 'sdate_save' );
function sdate_save( $post_id ){
    global $post;
    // Bail if we're doing an auto save
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

    // if our current user can't edit this post, bail
    if( !current_user_can( 'edit_post',$post_id ) ) return;

    if( isset( $_POST['stdate'] ) ){
        $startdate = $_POST['stdate'];


        update_post_meta( $post_id, 'stdate', $startdate, false );

    }

}
add_action( 'save_post', 'edate_save' );
function edate_save( $post_id ){
    global $post;
    // Bail if we're doing an auto save
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

    // if our current user can't edit this post, bail
    if( !current_user_can( 'edit_post',$post_id ) ) return;

    if( isset( $_POST['endate'] ) ){
        $enddate = $_POST['endate'];


        update_post_meta( $post_id, 'endate', $enddate, false );

    }

}

add_action( 'save_post', 'space_left' );
function space_left( $post_id ){
    global $post;

    $peopleno=0;
    // Bail if we're doing an auto save
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

    // if our current user can't edit this post, bail
    if( !current_user_can( 'edit_post',$post_id ) ) return;
    $tripbook_type=get_post_meta($post_id,'tripbook_type',true);

    if($tripbook_type=='fixed') {

        $prebook_status=(int)get_post_meta($post_id,'booking_status');

        if ($_POST['booking_status'] == 1) {

            $peopleno = $_POST['peopleno'];

            $posid = get_post_field('pos_id', $post_id);
            $spacerow = get_post_field('spacerow', $post_id)-1;

            //$rows = get_post_meta($posid,'fixed_departure',false);
            $rows = get_field('fixed_departure', $posid); // get all the rows
            // get all the rows
            $specific_row = $rows[$spacerow]; // 0 will get the first row, remember that the count starts at 0
            $sub_field_value = $specific_row['group_size']; // get the sub field value
            $totalpeople = $sub_field_value - $peopleno;

               
           // update_sub_row('max_people', $totalpeople, $spacerow, $posid);
          // update_sub_field(array('fixed_departure',$spacerow,'max_people'), $totalpeople, $posid);
           update_post_meta( $posid, 'fixed_departure_'.$spacerow.'_group_size', $totalpeople );
        } elseif ($_POST['booking_status'] == 0 && $prebook_status== 1 ) {

            $peopleno = $_POST['peopleno'];

            $posid = get_post_field('pos_id', $post_id);
            $spacerow = get_post_field('spacerow', $post_id)-1;
            $rows = get_field('fixed_departure', $posid); // get all the rows
            $specific_row = $rows[$spacerow]; // 0 will get the first row, remember that the count starts at 0
            $sub_field_value = $specific_row['group_size']; // get the sub field value

            $totalpeople = $sub_field_value + $peopleno;
          // update_sub_row('max_people', $totalpeople, $spacerow, $posid);
//            update_sub_field(array('max_people',$spacerow), $totalpeople, $posid);
            update_post_meta( $posid, 'fixed_departure_'.$spacerow.'_group_size', $totalpeople );
        }
     elseif ( $_POST['booking_status'] == 2 && $prebook_status==1) {

        $peopleno = $_POST['peopleno'];

        $posid = get_post_field('pos_id', $post_id);
        $spacerow = get_post_field('spacerow', $post_id)-1;
        $rows = get_field('fixed_departure', $posid); // get all the rows
        $specific_row = $rows[$spacerow]; // 0 will get the first row, remember that the count starts at 0
        $sub_field_value = $specific_row['group_size']; // get the sub field value

        $totalpeople = $sub_field_value + $peopleno;
        // update_sub_row('max_people', $totalpeople, $spacerow, $posid);
//            update_sub_field(array('max_people',$spacerow), $totalpeople, $posid);
        update_post_meta( $posid, 'fixed_departure_'.$spacerow.'_group_size', $totalpeople );
    }

}

}

add_filter('manage_booking_list_posts_columns', 'headerlisttable');
function headerlisttable( $defaults ) {
    $defaults['full_name']  = 'Full Name';
    $defaults['status']    = 'Status';
    // $defaults['venue']   = 'Venue';
    // $defaults['author'] = 'Added By';
    return $defaults;
}

add_action( 'manage_booking_list_posts_custom_column', 'colbookname', 10, 2 );

function colbookname( $column_name, $post_id ) {
    if ($column_name == 'full_name') {
        $full_name = get_post_meta( $post_id, 'name', true );
        echo $full_name;
    }

    if ($column_name == 'status') {
        $status = get_post_meta( $post_id, 'booking_status', true );
        if( $status==1){
            // approved
            echo "<span style='background-color:#4CFBCB; color:#fff;padding: 5px; font-weight:bold'>Approved</span>";
        }else if( $status==2){
            // rejectd
            echo "<span style='background-color:#F24335; color:#fff;padding: 5px; font-weight:bold'>Rejected</span>";
        }else{
            // pending
            echo "<span style='background-color:#EEBD62; color:#fff;padding: 5px; font-weight:bold'>Pending</span>";
        }
    }


}
add_filter( 'wp_mail_from', 'my_mail_from' );
function my_mail_from( $email ) {
    return "wordpress@jugalholidays.com";
}

add_filter( 'wp_mail_from_name', 'my_mail_from_name' );
function my_mail_from_name( $name ) {
    return "Jugal Holidays";
}


// add_action( 'phpmailer_init', 'configure_smtp' );
// function configure_smtp( PHPMailer $phpmailer ){
//     $phpmailer->isSMTP(); //switch to smtp
//     $phpmailer->Host = 'mail.mydomain.com';
//     $phpmailer->SMTPAuth = true;
//     $phpmailer->Port = 25;
//     $phpmailer->Username = 'Username Here';
//     $phpmailer->Password = 'myemailpassword';
//     $phpmailer->SMTPSecure = false;
//     $phpmailer->From = 'From Email Here';
//     $phpmailer->FromName='Sender Name';
// 	}


?>
