<?php get_header();
	
	$post_id = get_the_ID();


 ?>

<section class="single-package-s">
	<div class="tc-wrapper">
		<div class="row">
			<div class="col-lg-8">
				<div class="title-img m-b2">
					<h3><?php echo get_the_title($post_id);?></h3>
					<ul class="nav nav-tabs" id="myTab" role="tablist">
						<li class="nav-item">
						    <a class="nav-link active" id="photo-tab" data-toggle="tab" href="#photo" role="tab" aria-controls="photo" aria-selected="true"><i class="fa fa-camera"></i> &nbsp;Photos</a>
						</li>
						<li class="nav-item">
						    <a class="nav-link" id="map-tab" data-toggle="tab" href="#map" role="tab" aria-controls="map" aria-selected="false"><i class="fa fa-map-marker-alt"></i> &nbsp;On the Map</a>
						</li>
						<li class="nav-item">
						    <a class="nav-link" id="video-tab" data-toggle="tab" href="#video" role="tab" aria-controls="video" aria-selected="false"><i class="fab fa-youtube"></i> &nbsp;Video</a>
						</li>
					</ul>
					<div class="tab-content" id="imgTabContent">
						<div class="tab-pane fade show active" id="photo" role="tabpanel" aria-labelledby="photo-tab">
							<div class="trip-img">
								<?php if(empty(get_the_post_thumbnail_url($post_id)) && empty(acf_photo_gallery('gallery', $post_id))){ ?>
		                        <h5 style="display: none;">No Photo Gallery Found...</h5>
		                        <?php
		                        	}else{
		                        ?>
								<ul id="image-gallery" class="gallery list-unstyled cS-hidden">

		                            <li data-thumb="<?php echo get_the_post_thumbnail_url($post_id); ?>">
		                                <img src="<?php echo get_the_post_thumbnail_url($post_id); ?>"/>
		                            </li>
		                            <!-- for gallery -->
		                            <?php $gallery=acf_photo_gallery('gallery', $post_id);
		                            	if(!empty($gallery)){
		                            		foreach($gallery as $image ){
                                    $id = $image['id']; // The attachment id of the media
                                    $title = $image['title']; //The title
                                    $caption= $image['caption']; //The caption
                                    $ful_image_url= $image['full_image_url']; //Full size image url
                                    $full_image_url = acf_photo_gallery_resize_image($ful_image_url, 262, 160); //Resized size to 262px width by 160px height image url
                                    $thumbnail_image_url= $image['thumbnail_image_url']; //Get the thumbnail size image url 150px by 150px
                                    $url= $image['url']; //Goto any link when clicked
                                    $target= $image['target']; //Open normal or new tab
                                    $alt = get_field('photo_gallery_alt', $id); //Get the alt which is a extra field (See below how to add extra fields)
                                    $class = get_field('photo_gallery_class', $id); //Get the class which is a extra field (See below how to add extra fields)
                                    

		                            ?>
		                            <li data-thumb="<?php echo $ful_image_url; ?>" >
		                                <img src="<?php echo $ful_image_url;?>"  alt="<?php echo $alt; ?>"/>
		                            </li>

		                            <?php
		                            	}
		                            }
		                            ?>
		                            
		                        </ul>
		                        <?php 

		                        	}

		                        ?>
							</div>
						</div>
						<div class="tab-pane fade" id="map" role="tabpanel" aria-labelledby="map-tab">
							<div class="single-map">
								<?php 
								
								$package_map = get_field('package_map');
								$location=get_field('google_route');
								
									if(!empty(get_field('package_map'))){
										?>
										<img src="<?php echo $package_map['url'];?>">
										<?php
									}
									elseif(!empty($location)){
										
										?>
										<div class="acf-map">
											<div class="marker" data-lat="<?php echo $location['lat']; ?>" data-lng="<?php echo $location['lng']; ?>"></div>
										</div>
										<?php
									}
								?>
								
							</div>
						</div>
						<div class="tab-pane fade" id="video" role="tabpanel" aria-labelledby="video-tab">
							<div class="single-video">
								<?php if(empty(get_field('video'))){
										?>
										<h5 >No Videos Found...</h5>
										<?php
								}else{
									echo get_field('video');
									?>
									<!-- <iframe width="100%" height="315" src="https://www.youtube.com/embed/GsPq9mzFNGY" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> -->
									<?php
								}
								?>
		                        
								
							</div>
						</div>
					</div>
				</div>
				<div class="trip-info m-b2">
					<ul class="nav nav-tabs" id="myTab" role="tablist">
						<li class="nav-item">
						    <a class="nav-link active" id="overview-tab" data-toggle="tab" href="#overview" role="tab" aria-controls="overview" aria-selected="true"><i class="fa fa-info-circle"></i> &nbsp;Overview</a>
						</li>
						<li class="nav-item">
						    <a class="nav-link" id="itinerary-tab" data-toggle="tab" href="#itinerary" role="tab" aria-controls="itinerary" aria-selected="false"><i class="fa fa-list-ul"></i> &nbsp;Itinerary</a>
						</li>
						<li class="nav-item">
						    <a class="nav-link" id="inc-exc-tab" data-toggle="tab" href="#inc-exc" role="tab" aria-controls="inc-exc" aria-selected="false"><i class="fa fa-vote-yea"></i> &nbsp;Included</a>
						</li>
						<li class="nav-item">
						    <a class="nav-link" id="fix-dep-tab" data-toggle="tab" href="#fix-dep" role="tab" aria-controls="fix-dep" aria-selected="true"><i class="fab fa-telegram-plane"></i> &nbsp;Fixed Departure</a>
						</li>
						<li class="nav-item">
						    <a class="nav-link" id="review-tab" data-toggle="tab" href="#review" role="tab" aria-controls="review" aria-selected="false"><i class="fa fa-star-half-alt"></i> &nbsp;Reviews</a>
						</li>
					</ul>
					<div class="tab-content" id="imgTabContent">
						<div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview-tab">
							<div class="" id="trip-overview">
								<div class="row">
									<div class="col-lg-6 col-md-6">
										<h5 class="title-text text-uppercase">Trip overview</h5>
									</div>
									<div class="col-lg-6 col-md-6">
										<ul class="social-share">
											<?php echo do_shortcode('[ssba-buttons]'); ?>
											
										</ul>
									</div>
								</div>	
								<div class="row">
									<div class="col-lg-4 col-md-6 col-sm-6">
										<div class="tour-det ee">
											<h6>Trip Starts</h6>
											<h6><?php if(!empty(get_field('start_from'))){ echo get_field('start_from');}else{ echo 'NA';} ?></h6>
										</div>
									</div>
									<div class="col-lg-4 col-md-6 col-sm-6">
										<div class="tour-det ff">
											<h6>Trip Ends</h6>
											<h6><?php if(!empty(get_field('end_to'))){echo get_field('end_to');}else{
												echo 'NA';
											} ?></h6>
										</div>
									</div>
									<div class="col-lg-4 col-md-6 col-sm-6">
										<div class="tour-det aa">
											<h6>Group Size</h6>
											<h6><?php if(!empty( get_field('group_size'))){ echo get_field('group_size').' Persons';}else{echo 'NA';} ?> </h6>
										</div>
									</div>
									<div class="col-lg-4 col-md-6 col-sm-6">
										<div class="tour-det bb">
											<h6>Max Altitude</h6>
											<h6><?php if(!empty(get_field('altitude'))){ echo get_field('altitude').'m'; }else{ echo 'NA';}?></h6>
										</div>
									</div>
									<div class="col-lg-4 col-md-6 col-sm-6">
										<div class="tour-det cc">
											<h6>Fitness level</h6>
											<h6><?php if(!empty(get_field('fitness_level'))){ echo get_field('fitness_level');}else{echo "NA";} ?> </h6>
										</div>
									</div>
									<div class="col-lg-4 col-md-6 col-sm-6">
										<div class="tour-det dd">
											<h6>Destination</h6>
											<h6><?php if(!empty(get_field('destination'))){ echo get_field('destination');}else{ echo 'NA';} ?></h6>
										</div>
									</div>
									<div class="col-12">
										<div class="tab-desc">
											<p><?php if(!empty(get_field('overview'))){ 
												$overview=get_field('overview');
	echo $overview; }else{echo 'No overview available!';} ?></p>
										</div>
										<?php
										
										if(strlen($overview)>536){ ?> <div class="tab-desc-link"> 											<a href="#!" class="show">View More</a> </div> <?php } ?> 
										
									</div>
								</div>
							</div>
						</div>
						<div class="tab-pane fade" id="itinerary" role="tabpanel" aria-labelledby="itinerary-tab">
							<div class="row">
								<?php if(have_rows('itinerary')){
									while(have_rows('itinerary')){
										the_row();
										$title = get_sub_field('title');
										$details = get_sub_field('detail');
										?>
										<div class="col-12">
									<div class="iti-lists">
										<h6><?php echo $title;?><i class="fa fa-chevron-down"></i></h6>
										<div class="iti-content">
											<p><?php echo $details;?></p>
										</div>
									</div>
								</div>
										<?php
									}
								}else{
									echo '<h3>No Itinerary Found!</h3>';
									} 
								?>
								
								
							</div>
						</div>
						<div class="tab-pane fade" id="inc-exc" role="tabpanel" aria-labelledby="inc-exc-tab">
							<div class="included">
								<div class="row">
									<div class="col-12">
										<h3>What's Included</h3>
									</div>
								</div>
								<?php echo get_field('included'); ?>
								
							</div>
							<div class="excluded">
								<div class="row">
									<div class="col-12">
										<h3>What's Excluded</h3>
									</div>
								</div>
								<?php echo get_field('excluded'); ?>
								
							</div>
						</div>
						<div class="tab-pane fade" id="fix-dep" role="tabpanel" aria-labelledby="fix-dep-tab">
							<div class="group-tours">
								
									<?php
									if(have_rows('fixed_departure')){
										$count = count(get_field('fixed_departure'));
										?>
										<div class="fix-dep-list">
										<?php
										while (have_rows('fixed_departure')) {
												the_row();
												$sdate =get_sub_field('start_date');
											$disp_sdate=DateTime::createFromFormat('m-d-Y', $sdate);
												$edate = get_sub_field('end_date');
											$start_date = strtotime($sdate);

											$end_date = strtotime($edate);
											
											$num_of_days = ceil(($end_date-$start_date)/86400);
											$price2=get_field('price');
											$start_from2 = get_field('start_from');
											$maxpeople = get_sub_field('group_size');
											$spacerow = get_row_index();
											
											
										?>
										<table class="marg-t3 grp-list">
										<tr>
											<td class="p-l1 p-t1 p-b1">
												<table>
													<tbody><tr><th><?php if(!empty($sdate)){echo date('d M Y', $start_date); } ?></th></tr>
													<tr><td><?php if(!empty($start_from2)){ echo 'from '.$start_from2;}?></td></tr>
												</tbody></table>
											</td>
											<td class="p-t1 p-b1">
												<table>
													<tr><th>No. of Days</th></tr>
													<tr><td><?php if(!empty($num_of_days)){echo $num_of_days;}?></td></tr>
												</table>
											</td>
											<td class="p-t1 p-b1">
												<table>
													<tr><td>Price from</td></tr>
													<tr><th><?php if(!empty($price2)){ echo $price2.'<span>/p</span>';}else{echo 'NA';}?> </th></tr>
												</table>
											</td>
											<td>
												<a href="<?php echo home_url('/booking_list/?').'post_id='.$post_id.'&start_date='.$sdate.'&end_date='.$edate.'&maxpeople='.$maxpeople.'&spacerow='.$spacerow;?>" class="btn-grp-tour">Join Now</a>
											</td>
										</tr>
									</table>
										<?php

										}
									
										?>
									
									
								</div>
								<?php
									if($count>4){
								?>
								<div class="grp-tour-link">
									<a href="#!" class="view-more btn-success show">View More Tours</a>
								</div>
							<?php 
								}
							}else{
									?>
								<h3>
									No Fixed Departure Found!
								</h3>
								<?php
									}
						 ?>
						 
    						    <div class="customize_trip">
    						        <h5>Click to Customize your Trip</h5>
    						        <div class="customize_form">
    						            <?php echo do_shortcode('[contact-form-7 id="192" title="Customize Trip"]'); ?>
    						        </div>
    						    </div>
							</div>
						</div>
						<div class="tab-pane fade" id="review" role="tabpanel" aria-labelledby="review-tab">
							<div class="single-review">
								<?php echo do_shortcode('[site_reviews assigned_to="'.$post_id.'"]'); 
								echo do_shortcode('[site_reviews_form assign_to="'.$post_id.'"]'); 
								
								
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-4">
				<div class="single-sidebar sidebar-tab1">
					<a href="<?php echo home_url('/booking_list/?').'post_id='.$post_id.'&start_date='.''.'&end_date='.''.'&maxpeople='.get_field('group_size').'&spacerow=';?>" class="btn btn-book-now btn-success">Book this Trip</a>
					<h4>Price: <span><?php if(!empty(get_field('price'))){ echo '$'.get_field('price');}else{ echo 'NA';} ?><span>&nbsp;/p</span></span></h4>
<!-- 					<h6>See Group Discount</h6>
 -->					<!-- <table class="table table-hover group-discount">
						<thead>
						    <tr>
						      	<th>No. of people</th>
						      	<th>Price per person</th>
						    </tr>
						</thead>
						<tbody>
						    <tr>
						      	<td>1 - 1</td>
						      	<td>$1396</td>
						    </tr>
						    <tr>
							    <td>2 - 5</td>
							    <td>$1098</td>
						    </tr>
						    <tr>
							    <td>6 - 9</td>
							    <td>$1048</td>
						    </tr>
						    <tr>
							    <td>10+</td>
							    <td>$982</td>
						    </tr>
						</tbody>
					</table>
					<input type="text" class="form-control" data-toggle="datepicker" placeholder="Pick Your Date">
					<a href="#!" class="btn btn-book-now btn-blue">Check Availability</a> -->
				</div>
				
						<?php 
						$package_type1 = get_the_terms( $post_id, 'package_type' );
						$type1 = array();
						if(!empty($package_type1)){
						foreach($package_type1 as $package_types1){

                        array_push($type1,$package_types1->slug);
                    }
							$args1 = array(
								'post__not_in' => array($post_id),
                        		'package_type'=>$type1,
								'posts_per_page'=>'5',
							);
							$query1 = new WP_Query($args1);
							if($query1->have_posts()){
								?>
				<div class="single-sidebar sidebar-tab2">
					<h3 class="single-title">Related Packages</h3>
					<div class="row">
				<?php
								while($query1->have_posts()){
									$query1->the_post();
									$postid1 = get_the_ID();
									$title1 = get_the_title($postid1);
									$price1 = get_field('price');
									$thumbnail1 = get_the_post_thumbnail_url($postid1);
									$permalink1 = get_the_permalink($postid1);
									
									?>
										<div class="col-lg-12 col-md-4 col-sm-6">
                							<div class="row">
                								<div class="col-lg-5">
                									<a href="<?php echo $permalink1; ?>"><img src="<?php if(!empty($thumbnail1)){ echo $thumbnail1;} ?>"></a>
                								</div>
                								<div class="col-lg-7 padd-0">
                									<div class="related-package">
                										<h3><a href="<?php echo $permalink1; ?>"><?php if(!empty($title1)){echo $title1;}else{echo 'No Title';} ?></a></h3>
                										<h5>Price: <span><?php if(!empty($price1)){echo '$'.$price1;}else{ echo 'NA'; }?></span></h5>
                									</div>
                								</div>
                							</div>
						                </div>
									<?php
								}
								?>
						</div>
				</div>
						<?php
							}
						}
						?>
						
						
					
				<div class="single-sidebar sidebar-tab3">
					<h3 class="single-title">Trip Advisor Review</h3>
						<div id="TA_selfserveprop52" class="TA_selfserveprop"><ul id="R0PIFMtg44E" class="TA_links j1mhq5tT"><li id="oZhilby" class="tcYUPuhGOKq"><a target="_blank" href="https://www.tripadvisor.com/"><img src="https://www.tripadvisor.com/img/cdsi/img2/branding/150_logo-11900-2.png" alt="TripAdvisor"/></a></li></ul></div><script async src="https://www.jscache.com/wejs?wtype=selfserveprop&amp;uniq=52&amp;locationId=17343577&amp;lang=en_US&amp;rating=true&amp;nreviews=5&amp;writereviewlink=true&amp;popIdx=true&amp;iswide=false&amp;border=true&amp;display_version=2" data-loadtrk onload="this.loadtrk=true"></script>
<!-- 					<h4>No Trip Advisor</h4> -->
				</div>
				<div class="single-sidebar sidebar-tab4">
					<h3 class="single-title">Need Help?</h3>
					<ul class="single-contact">
						<li class="flaticon-phone"><?php 
										$my_option = get_option('jugal_framework');
										$phones = $my_option['contact'];
										if(!empty($phones)){
											$cnt = count($phones);
											
											$j=1;
											foreach($phones as $phone){
												
												if($j <= 1){
													?>
													<a href="tel:<?php echo $phone['contact_number'];?>"><?php echo $phone['contact_number'];?></a>
												<?php 
											}
												$j++;
											}
										}
									?></li>
						<li class="flaticon-close-envelope"><?php
										$emails = $my_option['cont_email'];
										if(!empty($emails)){
											$cnt = count($emails);
											$i=1;
											foreach($emails as $email){
												
												if($i <= 1 ){
													?>
													<a href="mailto:<?php echo $email['contact_email'];?>"><?php echo $email['contact_email'];?></a>
												<?php 
											}
												$i++;
											}
										}
									?></li>
					</ul>
					<div class="quick-enquiry">
					    <?php echo do_shortcode('[contact-form-7 id="167" title="Single Page Contact Form"]'); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php get_footer(); ?>
<script>
    $(document.ready(function(){
        $('.mega-menu-toggle-block').click(function(){
            $(this).parents('.mega-menu-wrap').find('#mega-menu-wrap-menu-1').slideToggle();
        });
    });
</script>