<?php get_header(); 
$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

?>
<!-- section banner starts -->
<section class="banner page-banner" style="background-image: url(<?php echo home_url(); ?>/wp-content/uploads/2020/06/backpacker-772991_1920-scaled.jpg)">
	<div class="tc-wrapper">
		<h1 class="banner-title">
		Our Excursion
		</h1>
		<a href="<?php echo home_url(); ?>/enquiry-form" class="btn-one">Enquiry Now</a>
	</div>
</section>
<!-- section banner ends -->
<div class="category-overview sp-tb">
	<div class="tc-wrapper">
		<div class="overview-inner">
			<h4>Introduction to the title</h4>
			<p>
				Besides, with our experts' help, you can tailor and customize your perfect trip designed around your requirements. We have more than two decades of experience in planning adventure holidays in the Himalayas. We specialize in organizing small group tours, private and tailor-made holidays designed to match your needs. Our trips are fully supported and we offer personalized service to our clients. The care and attention that we put into your trip ensure that your holiday is more enriching and satisfying. 
			</p>
			<h4>Things to do</h4>
			<p>There is so much to do in Nepal that you’ll be spoilt for choice. While Trekking in Nepal is the most popular activity, visitors also find other outdoor activities equally engaging. Activities on offer include short day hikes, cultural tours, food tours, photography tours, adventure activities like rafting, bungy jumping, mountain biking, paragliding, rock climbing, etc.</p>
		</div>
	</div>
</div>
<section class="category-wrapper sp-t sp-b">
	<div class="tc-wrapper">
		<div class="category-heading">
			<h3>Nepal Tours & Itineraries</h3>
			<span>Get inspired by trips other travelers have loved</span>
		</div>
		<div class="category-filter">
			<div class="row">
				<div class="font col-lg-7 col-md-6">
					<h1 style="display:none;">
						Jugal holidays
					</h1>
					<h3>Package Type: Our Excursion<span> (<?php echo $term->count;?>)</span> </h3>
				</div>
				<div class="col-lg-5 col-md-6">
					<ul class="cat-title-r">
						<li>
							<div class="category-sort sorter">
								Sort By 
								<select id = "sort" name="sort_trip">
									<option value=''>Select Item</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='popular_trip'){echo 'selected';}?> value="popular_trip">Popularity</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='recent'){echo 'selected';}?> value="recent" >Recent</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='trending'){echo 'selected';}?> value="trending">Trending</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='adventure_trip'){echo 'selected';}?> value="adventure_trip">Adventure</option>
									<option <?php if(isset($_GET['sort'])&& $_GET['sort']=='best_offer'){echo 'selected';}?> value="best_offer">Best Sales</option>
								</select>
							</div>
						</li>
						<li>
							<div class="sort">
								<ul class="nav nav-tabs" id="myTab" role="tablist">
									<li class="nav-item">
										<a class="nav-link active" id="list-tab" data-toggle="tab" href="#list" role="tab" aria-controls="list" aria-selected="true"><i class="fa fa-list"></i></a>
									</li>
									<li class="nav-item">
										<a class="nav-link " id="grid-tab" data-toggle="tab" href="#grid" role="tab" aria-controls="grid" aria-selected="true"><i class="fa fa-th"></i></a>
									</li>

								</ul>
							</div>
						</li>
					</ul>
				</div>
			</div>
		</div>
		<?php 
		if(have_posts()){
			global $wp_query;
			if(isset($_GET['sort'])){
				$sort = $_GET['sort'];
				if($sort=='recent'){
					$order_by = 'publish_date';
					$order = 'ASC';
					$sort_key = '';
				}else{
					$order_by = 'meta_value';
					$order = 'ASC';
					$sort_key =$sort;
				}

			}


					//$paginate =  (get_query_var('paged')) ? get_query_var('paged'): 1; 
					//$paged3 = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;



			?>

			<div class="tab-content page-content" id="imgTabContent">
				<!-- //list view -->
				<div class="tab-pane fade show active" id="list" role="tabpanel" aria-labelledby="list-tab">
					<div class="change_ajax_list">
						<div class="row-none"><br>
							<?php

							$argsf = array(
								'post_type' =>'package',
								 'tax_query' => array(
        array(
            'taxonomy' => 'package_type',
            'field'    => 'slug',
            'terms'    => 'Popular Trips',
            ),
        )

							);
							$queryf = new WP_Query($argsf);
								while($queryf->have_posts()){
									$queryf->the_post();
									$duration = get_field('duration');


										?>
<div class="col-lg-12-none">
									<div class="category-details">
						    <div class="row">
											<div class="col-lg-4">
												<div class="cat-img">
													<a class="imagewrap" href="<?php the_permalink() ?>">
														<h2 class="title-tour"><?php the_title() ?></h2>
														<img alt="Featured Image" data-src="" class=" ls-is-cached lazyloaded" src="<?php echo get_the_post_thumbnail_url() ?>"><noscript><img src="<?php echo get_the_post_thumbnail_url() ?>" alt="Featured Image"></noscript>
													</a>
												</div>
											</div>
											<div class="col-lg-8">
												<div class="right-parts">
													<div class="actions right-section">
														<div class="row">
															<div class="col-lg-4 col-md-4 col-sm-4">
																<h3 class="pricetag d-none"><i class="fas fa-tags"></i> $60</h3>
															</div>
															<div class="col-lg-8 col-md-8 col-sm-8">
																<div class="content-bar">
																	<div class="duration">
																		<h6 align="center">Duration: <?php echo $duration ?></h6>
																	</div>
																	<div class="view-btn">
																		<a class="btn btn-button" href="<?php the_permalink() ?>">VIEW TOUR</a>
																	</div>
																</div>
															</div>
														</div>
													</div>
													<div class="category-section">
														<div class="col-lg-12"> 
															<div class="category-description">
																<div class="category-info">
																	<p>
JugalHoliday's top excursion: "Enchanting Himalayan Trek." Unforgettable journey through Himalayan landscapes, cultural immersion, and stunning vistas. Expert-guided trek, remote villages, camping under starry skies. Ideal for nature lovers and adventure seekers.</p>
																		</div>
																		<div class="package">
																			<div class="features">
																				<h4> Features </h4>
																			</div>
																			<table class="table tables table-borderless">
																				<tbody><tr>
																					<td width="2%"><i class="fas fa-users"></i></td>
																					<td> Group Size</td>
																					<td>- 1-16 Persons</td>
																				</tr>
																				<tr>
																					<td><i class="fas fa-utensils"></i></td>
																					<td> Meals</td>
																					<td>- N/A</td>
																				</tr>
																				<tr>
																					<td><i class="fas fa-bed"></i></td>
																					<td> Accomodation</td>
																					<td>- N/A</td>
																				</tr>
																			</tbody></table>
																		</div>                                              
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
													</div>
														</div>
												<?php } ?>
							<?php
							$per_page = 9;
							$offset = 0;
							$currentpage = 1;
							if(isset($_GET['sort'])){
								query_posts( array_merge( $wp_query->query, array( 'posts_per_page' => $per_page, 'offset'=>$offset,'paged'=>1,'meta_key'   => $sort_key,
									'orderby'    => $order_by, 'order'=>$order) ) );
							}else{
								query_posts( array_merge( $wp_query->query, array( 'posts_per_page' => $per_page, 'offset'=>$offset,'paged'=>1) ) );

							}
							while(have_posts()){
								the_post();

								$post_id1 = get_the_ID();
								$trending1 = get_field('trending');
								$package_month1 = get_field('package_of_the_month');
								$popular1 = get_field('popular_trip');
								$adventure1 =get_field('adventure_trip');
								$best_offer1 = get_field('best_offer') ;
								$price1 = get_field('price');
								$duration1 = get_field('duration');
								$overview1 = get_field('overview');


								?>

								<div class="col-lg-12-none">
									<div class="category-details">
										<div class="row">
											<div class="col-lg-4">
												<div class="cat-img">
													<a class="imagewrap" href="<?php the_permalink( $post_id1 ); ?>">
														<h2 class="title-tour"><?php the_title();?></h2>
														<img src="<?php echo get_the_post_thumbnail_url($post_id1); ?>" alt="Featured Image">
													</a>
												</div>
											</div>
											<div class="col-lg-8">
												<div class="right-parts">
													<div class="actions right-section">
														<div class="row">
															<div class="col-lg-4 col-md-4 col-sm-4">
																<h3 class="pricetag d-none"><i class="fas fa-tags"></i> $<?php echo $price1; ?></h3>
															</div>
															<div class="col-lg-8 col-md-8 col-sm-8">
																<div class="content-bar">
																	<div class="duration">
																		<h6 align="center">Duration: <?php echo $duration1; ?></h6>
																	</div>
																	<div class="view-btn">
																		<a class="btn btn-button" href="<?php the_permalink( $post_id1 ); ?>" >VIEW TOUR</a>
																	</div>
																</div>
															</div>
														</div>
													</div>
													<div class="category-section">
														<div class="col-lg-12"> 
															<div class="category-description">
																<div class="category-info">
																	<p>
																		<?php if(!empty($overview1)){ echo wp_trim_words($overview1,25);} 
																		if(str_word_count($overview1)>25){
																			?><a href="<?php the_permalink( $post_id1 ); ?>">Read More</a>
																			<?php } ?></p>
																		</div>
																		<div class="package">
																			<div class="features">
																				<h4> Features </h4>
																			</div>
																			<table class="table tables table-borderless">
																				<tr>
																					<td width="2%"><i class="fas fa-users"></i></td>
																					<td> Group Size</td>
																					<td>- <?php echo get_field('group_size')?> Persons</td>
																				</tr>
																				<tr>
																					<td><i class="fas fa-utensils"></i></td>
																					<td> Meals</td>
																					<td>- <?php if(!empty(get_field('meal'))){ echo get_field('meal'); }else{echo 'N/A';} ?></td>
																				</tr>
																				<tr>
																					<td><i class="fas fa-bed"></i></td>
																					<td> Accomodation</td>
																					<td>- <?php if(!empty(get_field('accomodation'))){ echo get_field('accomodation'); }else{echo 'N/A';} ?></td>
																				</tr>
																			</table>
																		</div>                                              
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>


										<?php 
									}
									wp_reset_postdata();

									$num_of_page = $wp_query->max_num_pages;

									if($num_of_page>1){
										$pg=1;
										echo '<div class="col-12 pagination"><ul class="paginate" >';
										while( $pg <= $num_of_page ) {
											?>

											<li class="page-item page-num" ><a  class="<?php if ($pg == $currentpage) {
												echo 'active';
											} ?>"> <?php echo $pg; ?></a>

											<!-- required data to pass -->
											<input type="hidden" name="term" class="term" value="<?php echo $term->slug; ?>">
											<input type="hidden" name="display_typ" class="display_typ" value="list">
											<input type="hidden" name="per_page" class="per_page" value="<?php echo $per_page; ?>">
										</li>
										<?php
										$pg++;
									}
									echo '</ul></div>';
								}
								?>
							</div>
						</div>
					</div>

					<!-- //grid view -->

					<div class="tab-pane fade " id="grid" role="tabpanel" aria-labelledby="grid-tab">
						<div class="change_ajax_grid">
							<div class="row">
								<?php
								if(isset($_GET['sort'])){
									query_posts( array_merge( $wp_query->query, array( 'posts_per_page' => $per_page, 'offset'=>$offset,'paged'=>1,'meta_key'   => $sort_key,
										'orderby'    => $order_by, 'order'=>$order) ) );
								}else{
									query_posts( array_merge( $wp_query->query, array( 'posts_per_page' => $per_page, 'offset'=>$offset,'paged'=>1) ) );

								}
								while(have_posts()){
									the_post();

									$post_id1 = get_the_ID();
									$post_title1 = get_the_title();
									$trending1 = get_field('trending');
									$package_month1 = get_field('package_of_the_month');
									$popular1 = get_field('popular_trip');
									$adventure1 =get_field('adventure_trip');
									$best_offer1 = get_field('best_offer') ;
									$price1 = get_field('price');
									$duration1 = get_field('duration');
									$overview1 = get_field('overview');
									?>

									<div class="col-lg-4 col-md-6 col-sm-6">
										<div class="card-item-popular">
											<div class="image">
												<a href="<?php the_permalink( $post_id1 ); ?>">
													<img src="<?php echo get_the_post_thumbnail_url($post_id1); ?>">
												</a>
											</div>
											<div class="pop-trip-detail">
												<span class="trip-category">Trekking & Hiking</span>
												<h5><?php the_title();?></h5>
												<div class="trip-det">
													<h6 class="trp-dest">
														Destination
														<span>Nepal</span>
													</h6>
													<h6 class="level">
														Difficultu Level
														<span>Moderate</span>
													</h6>
												</div>
												<div class="trp-review">
													<div class="review-content">
														<div class="rating">
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
														</div>
														<span class="totalreview">25 Reviews</span>
													</div>
													<a href="<?php the_permalink( $post_id2 ); ?>" class="btn-button">View Details</a>
												</div>

<!-- 												<div class="trip-price d-none">
													<span>$<?php echo $price1; ?></span>
												</div> -->
											</div>
											<!-- <h5 class="title-nhov"><?php echo $post_title1;?></h5> -->
										</div>
									</div>
									<?php
								}
								wp_reset_postdata();
								$num_of_page = $wp_query->max_num_pages;
								if($num_of_page>1){
									$pg=1;
									echo '<div class="col-12 pagination d-none"><ul class="paginate" >';
									while( $pg <= $num_of_page ) {
										?>

										<li class="page-item page-num" ><a class="<?php if ($pg == $currentpage) {
											echo 'active';
										}else{echo '';} ?>"> <?php echo $pg; ?></a>

										<!-- required data to pass -->
										<input type="hidden" name="term" class="term" value="<?php echo $term->slug; ?>">
										<input type="hidden" name="display_typ" class="display_typ" value="grid">
										<input type="hidden" name="per_page" class="per_page" value="<?php echo $per_page; ?>">
									</li>
									<?php
									$pg++;

								}
								echo '</ul></div>';
							}

							?>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
		?>

	</div>
<!-- 	</div> -->
</section>
<!--=====Blog Section=====-->
<section class="blogs cat-blog bg-blue sp-tb">
	<div class="tc-wrapper">
		<div class="section-heading">
			<h4 class="site-subtitle">Blog</h4>
			<h3 class="site-title">Latest <a href="<?php echo home_url(); ?>/blog"><span>Blog</span></a></h3>
			<div class="title-icon">
				<i class="fas fa-running"></i>
			</div>
		</div>
		<div class="row">
			<?php 
			$args6 = array(
				'post_type' => 'post',
				'taxonomy' => 'category',
				'term' => 'blog',
				'posts_per_page' => 3,
			);

			$query6 = new WP_Query($args6);
			if($query6->have_posts()){
				while($query6->have_posts()){
					$query6->the_post();
					$post_id6 = get_the_ID();
					$post_title6 = get_the_title($post_id6);
					$post_content6 = get_the_content($post_id6);
					$post_image6 = get_the_post_thumbnail_url($post_id6);
					$post_date6 = get_the_date('F j, Y',$post_id6); 
					?>
					<div class="col-lg-4 col-md-6 col-sm-6">
						<div class="blog-list">
							<div class="image">
								<a href="<?php the_permalink(); ?>"><img src="<?php echo $post_image6; ?>" alt="Jugal Holidays"></a>
							</div>
							<div class="blog-det">
								<h4><a href="<?php the_permalink($post_id6);?>"><?php echo $post_title6;?></a></h4>
								<ul class="date-cat">
									<li class="date"><span><?php echo $post_date6;?></span></li>
								</ul>
								<div class="description">
									<?php echo wp_trim_words( $post_content6,  14 );?>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
			}
			?>

		</div>
	</div>
</section>
<!--=====End Blog Section=====-->
<?php get_footer(); ?>